/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.http.internal;

import com.ksyun.ks3.signer.internal.FIFOCache;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import shadedforhadoopks3.org.apache.http.conn.DnsResolver;
import shadedforhadoopks3.org.apache.http.impl.conn.SystemDefaultDnsResolver;

public class Ks3DnsResolver
implements DnsResolver {
    private final Log log = LogFactory.getLog(this.getClass());
    public static final Ks3DnsResolver INSTANCE = new Ks3DnsResolver();
    private static final int CACHE_MAX_SIZE = 300;
    private static final FIFOCache<InetAddress[]> cache = new FIFOCache(300);

    @Override
    public InetAddress[] resolve(String host) throws UnknownHostException {
        InetAddress[] addressArr = null;
        try {
            addressArr = SystemDefaultDnsResolver.INSTANCE.resolve(host);
            if (addressArr != null) {
                cache.add(host, addressArr);
            }
            return addressArr;
        }
        catch (UnknownHostException e) {
            this.log.warn((Object)"Resolve host fail, will use cache. Cause:", (Throwable)e);
            addressArr = cache.get(host);
            if (addressArr != null) {
                return addressArr;
            }
            this.log.debug((Object)"Also not found in cache.");
            throw e;
        }
    }
}

