/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.request;

import com.ksyun.ks3.dto.Adp;
import com.ksyun.ks3.dto.CallBackConfiguration;
import com.ksyun.ks3.dto.ListPartsResult;
import com.ksyun.ks3.dto.Part;
import com.ksyun.ks3.dto.PartETag;
import com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator;
import com.ksyun.ks3.http.HttpHeaders;
import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.service.request.Ks3WebServiceRequest;
import com.ksyun.ks3.utils.HttpUtils;
import com.ksyun.ks3.utils.StringUtils;
import com.ksyun.ks3.utils.XmlWriter;
import java.io.ByteArrayInputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CompleteMultipartUploadRequest
extends Ks3WebServiceRequest {
    private String bucket;
    private String key;
    private String uploadId;
    private List<PartETag> partETags = new ArrayList<PartETag>();
    private CallBackConfiguration callBackConfiguration;
    private List<Adp> adps = new ArrayList<Adp>();
    private String notifyURL;

    public CompleteMultipartUploadRequest(String bucketname, String objectkey, String uploadId, List<PartETag> eTags) {
        this.bucket = bucketname;
        this.key = objectkey;
        this.uploadId = uploadId;
        if (eTags == null) {
            eTags = new ArrayList<PartETag>();
        }
        this.partETags = eTags;
    }

    public CompleteMultipartUploadRequest(ListPartsResult result) {
        this.bucket = result.getBucketname();
        this.key = result.getKey();
        this.uploadId = result.getUploadId();
        for (Part p : result.getParts()) {
            PartETag tag = new PartETag();
            tag.seteTag(p.getETag());
            tag.setPartNumber(p.getPartNumber());
            this.partETags.add(tag);
        }
    }

    public CompleteMultipartUploadRequest(String bucketname, String objectkey) {
        this.bucket = bucketname;
        this.key = objectkey;
    }

    public void addETag(PartETag eTag) {
        if (this.partETags == null) {
            this.partETags = new ArrayList<PartETag>();
        }
        this.partETags.add(eTag);
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public void setUploadId(String uploadId) {
        this.uploadId = uploadId;
    }

    public List<PartETag> getPartETags() {
        return this.partETags;
    }

    public void setPartETags(List<PartETag> partETags) {
        this.partETags = partETags;
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public CallBackConfiguration getCallBackConfiguration() {
        return this.callBackConfiguration;
    }

    public void setCallBackConfiguration(CallBackConfiguration callBackConfiguration) {
        this.callBackConfiguration = callBackConfiguration;
    }

    public List<Adp> getAdps() {
        return this.adps;
    }

    public void setAdps(List<Adp> adps) {
        this.adps = adps;
    }

    public String getNotifyURL() {
        return this.notifyURL;
    }

    public void setNotifyURL(String notifyURL) {
        this.notifyURL = notifyURL;
    }

    @Override
    public void buildRequest(Request request) {
        request.setMethod(HttpMethod.POST);
        request.setBucket(this.bucket);
        request.setKey(this.key);
        XmlWriter writer = new XmlWriter();
        writer.start("CompleteMultipartUpload");
        for (PartETag tag : this.partETags) {
            writer.start("Part").start("PartNumber").value(tag.getPartNumber()).end().start("ETag").value(tag.geteTag()).end().end();
        }
        writer.end();
        String xml = writer.toString();
        request.setContent(new ByteArrayInputStream(xml.getBytes()));
        request.getQueryParams().put("uploadId", this.uploadId);
        if (this.callBackConfiguration != null) {
            String bodyString;
            request.addHeader(HttpHeaders.XKssCallbackUrl.toString(), this.callBackConfiguration.getCallBackUrl());
            StringBuffer body = new StringBuffer();
            if (this.callBackConfiguration.getBodyMagicVariables() != null) {
                for (Map.Entry<String, CallBackConfiguration.MagicVariables> entry : this.callBackConfiguration.getBodyMagicVariables().entrySet()) {
                    body.append(entry.getKey() + "=${" + (Object)((Object)entry.getValue()) + "}&");
                }
            }
            if (this.callBackConfiguration.getBodyKssVariables() != null) {
                for (Map.Entry<String, Object> entry : this.callBackConfiguration.getBodyKssVariables().entrySet()) {
                    body.append(entry.getKey() + "=${kss-" + entry.getKey() + "}&");
                    request.addHeader("kss-" + entry.getKey(), (String)entry.getValue());
                }
            }
            if ((bodyString = body.toString()).endsWith("&")) {
                bodyString = bodyString.substring(0, bodyString.length() - 1);
            }
            request.addHeader(HttpHeaders.XKssCallbackBody.toString(), bodyString);
            if (this.callBackConfiguration.getCallBackAuth().booleanValue()) {
                request.addHeader(HttpHeaders.XKssCallbackAuth, "1");
            }
        }
        if (this.adps != null && this.adps.size() > 0) {
            request.addHeader(HttpHeaders.AsynchronousProcessingList.toString(), URLEncoder.encode(HttpUtils.convertAdps2String(this.adps)));
            if (!StringUtils.isBlank(this.notifyURL)) {
                request.addHeader(HttpHeaders.NotifyURL.toString(), HttpUtils.urlEncode(this.notifyURL, false));
            }
        }
    }

    @Override
    public void validateParams() throws IllegalArgumentException {
        if (StringUtils.isBlank(this.bucket)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("bucketname");
        }
        if (StringUtils.isBlank(this.key)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("objectKey");
        }
        if (StringUtils.isBlank(this.uploadId)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("uploadId");
        }
        if (this.partETags == null) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("partETags");
        }
        if (this.callBackConfiguration != null && StringUtils.isBlank(this.callBackConfiguration.getCallBackUrl())) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("callBackConfiguration.callBackUrl");
        }
        if (this.adps != null && this.adps.size() > 0) {
            for (Adp adp : this.adps) {
                if (!StringUtils.isBlank(adp.getCommand())) continue;
                throw ClientIllegalArgumentExceptionGenerator.notNullInCondition("adps.command", "adps\u4e0d\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank(this.notifyURL)) {
                throw ClientIllegalArgumentExceptionGenerator.notNullInCondition("notifyURL", "adps\u4e0d\u4e3a\u7a7a");
            }
        }
    }
}

