/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.request;

import com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator;
import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.service.request.Ks3WebServiceRequest;
import com.ksyun.ks3.utils.StringUtils;

public class ListObjectsRequest
extends Ks3WebServiceRequest {
    private String bucket;
    private String prefix;
    private String marker;
    private String delimiter;
    private Integer maxKeys;
    private String encodingType;

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public Integer getMaxKeys() {
        return this.maxKeys;
    }

    public void setMaxKeys(Integer maxKeys) {
        this.maxKeys = maxKeys;
    }

    public ListObjectsRequest(String bucketName) {
        this(bucketName, null, null, null, null);
    }

    public ListObjectsRequest(String bucketName, String prefix) {
        this(bucketName, prefix, null, null, null);
    }

    public ListObjectsRequest(String bucketName, String prefix, String marker, String delimiter, Integer maxKeys) {
        this.bucket = bucketName;
        this.prefix = prefix;
        this.marker = marker;
        this.delimiter = delimiter;
        this.maxKeys = maxKeys;
    }

    @Override
    public void validateParams() throws IllegalArgumentException {
        if (StringUtils.isBlank(this.bucket)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("bucketName");
        }
        if (this.maxKeys != null && (this.maxKeys > 1000 || this.maxKeys < 1)) {
            throw ClientIllegalArgumentExceptionGenerator.between("maxKeys", String.valueOf(this.maxKeys), "1", "1000");
        }
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    public void setEncodingType(String encodingType) {
        this.encodingType = encodingType;
    }

    @Override
    public void buildRequest(Request request) {
        request.setMethod(HttpMethod.GET);
        request.setBucket(this.bucket);
        request.addQueryParamIfNotNull("prefix", this.prefix);
        request.addQueryParamIfNotNull("marker", this.marker);
        request.addQueryParamIfNotNull("delimiter", this.delimiter);
        if (this.maxKeys != null) {
            request.addQueryParamIfNotNull("max-keys", String.valueOf(this.maxKeys));
        }
        request.addQueryParamIfNotNull("encoding-type", this.encodingType);
    }
}

