/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.request;

import com.ksyun.ks3.dto.BucketMirror;
import com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator;
import com.ksyun.ks3.http.HttpHeaders;
import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.service.request.Ks3WebServiceRequest;
import com.ksyun.ks3.utils.Md5Utils;
import com.ksyun.ks3.utils.StringUtils;
import java.io.ByteArrayInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import shadedforhadoopks3.org.apache.http.entity.ContentType;

public class PutBucketMirrorRequest
extends Ks3WebServiceRequest {
    private static final Log log = LogFactory.getLog(PutBucketMirrorRequest.class);
    private String bucketName;
    private BucketMirror bucketMirror;

    public PutBucketMirrorRequest() {
    }

    public PutBucketMirrorRequest(String bucketName, BucketMirror bucketMirror) {
        this.bucketName = bucketName;
        this.bucketMirror = bucketMirror;
    }

    @Override
    public void buildRequest(Request request) {
        request.setMethod(HttpMethod.PUT);
        request.setBucket(this.bucketName);
        request.addQueryParam("mirror", "");
        String json = this.bucketMirror.toJson();
        log.debug((Object)("bucketmirror json:" + json));
        request.addHeader(HttpHeaders.ContentMD5, Md5Utils.md5AsBase64(json.getBytes()));
        request.addHeader(HttpHeaders.ContentType, ContentType.APPLICATION_JSON.toString());
        request.setContent(new ByteArrayInputStream(json.getBytes()));
    }

    @Override
    public void validateParams() {
        if (StringUtils.isBlank(this.bucketName)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("bucketName");
        }
        if (this.bucketMirror == null) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("bucketMirror");
        }
    }
}

