/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.response;

import com.ksyun.ks3.AutoAbortInputStream;
import com.ksyun.ks3.config.Constants;
import com.ksyun.ks3.dto.GetObjectResult;
import com.ksyun.ks3.dto.ObjectMetadata;
import com.ksyun.ks3.http.HttpHeaders;
import com.ksyun.ks3.service.response.Ks3WebServiceStreamResponse;
import com.ksyun.ks3.utils.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import shadedforhadoopks3.org.apache.http.Header;

public class GetObjectResponse
extends Ks3WebServiceStreamResponse<GetObjectResult> {
    private static Log log = LogFactory.getLog(GetObjectResponse.class);

    @Override
    public int[] expectedStatus() {
        return new int[]{200, 206, 304, 412};
    }

    @Override
    public void preHandle() {
        ObjectMetadata metaData = new ObjectMetadata();
        this.result = new GetObjectResult();
        int statusCode = this.getHttpResponse().getStatusLine().getStatusCode();
        if (statusCode == 200 || statusCode == 206) {
            ((GetObjectResult)this.result).getObject().setObjectContent(new AutoAbortInputStream(this.getContent(), this.getHttpRequest()));
            ((GetObjectResult)this.result).getObject().setRedirectLocation(this.getHeader(HttpHeaders.XKssWebsiteRedirectLocation.toString()));
            Header[] headers = this.getHttpResponse().getAllHeaders();
            for (int i = 0; i < headers.length; ++i) {
                if (headers[i].getName().startsWith(Constants.userMetaPrefix)) {
                    metaData.setUserMeta(headers[i].getName(), headers[i].getValue());
                    continue;
                }
                String key = headers[i].getName();
                String value = headers[i].getValue();
                if (Constants.KS3_IGNOREG_HEADERS.contains(key)) continue;
                if (key.equals(HttpHeaders.LastModified.toString())) {
                    try {
                        metaData.setLastModified(DateUtils.convertStr2Date(value));
                    }
                    catch (Exception pe) {
                        log.warn((Object)("Unable to parse last modified date: " + value), (Throwable)pe);
                    }
                    continue;
                }
                if (key.equals(HttpHeaders.ContentLength.toString())) {
                    try {
                        metaData.setHeader(key, Long.parseLong(value));
                    }
                    catch (NumberFormatException nfe) {
                        log.warn((Object)("Unable to parse content length: " + value), (Throwable)nfe);
                    }
                    continue;
                }
                if (key.equals(HttpHeaders.ETag.toString())) {
                    metaData.setHeader(key, value.replace("\"", ""));
                    continue;
                }
                if (key.equals(HttpHeaders.ContentMD5.toString())) {
                    metaData.setHeader(HttpHeaders.ContentMD5.toString(), value.replace("\"", ""));
                    continue;
                }
                if (key.equals(HttpHeaders.Expires.toString())) {
                    try {
                        metaData.setHttpExpiresDate(DateUtils.convertStr2Date(value));
                    }
                    catch (Exception pe) {
                        log.warn((Object)("Unable to parse http expiration date: " + value), (Throwable)pe);
                    }
                    continue;
                }
                metaData.setHeader(key, value);
            }
            ((GetObjectResult)this.result).getObject().setObjectMetadata(metaData);
        } else if (statusCode == 304) {
            ((GetObjectResult)this.result).setIfModified(false);
        } else if (statusCode == 412) {
            ((GetObjectResult)this.result).setIfPreconditionSuccess(false);
        }
    }
}

