/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.signer;

import com.ksyun.ks3.dto.Authorization;
import com.ksyun.ks3.exception.Ks3ClientException;
import com.ksyun.ks3.http.HttpHeaders;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.service.Ks3ClientConfig;
import com.ksyun.ks3.signer.Ks3V4Signer;
import com.ksyun.ks3.signer.Signer;
import com.ksyun.ks3.utils.AuthUtils;

public class DefaultSigner
implements Signer {
    @Override
    public void sign(Authorization auth, Request request) {
        try {
            if (!request.isPresign()) {
                if (auth.getSecurityToken() != null) {
                    request.addHeader(HttpHeaders.XKssSecurityTokenHeader.toString(), auth.getSecurityToken());
                }
                request.addHeader("Authorization".toString(), AuthUtils.calcAuthorization(auth, request));
            } else {
                if (auth.getSecurityToken() != null) {
                    request.getQueryParams().put("security-token", auth.getSecurityToken());
                }
                request.getQueryParams().put("AccessKeyId", auth.getAccessKeyId());
                request.getQueryParams().put("Signature", AuthUtils.calcSignature(auth.getAccessKeySecret(), request));
                request.getQueryParams().put("Expires", String.valueOf(request.getExpires().getTime() / 1000L));
            }
        }
        catch (Exception e) {
            throw new Ks3ClientException("\u8ba1\u7b97\u7528\u6237\u7b7e\u540d\u65f6\u51fa\u9519(" + e + ")", e);
        }
    }

    @Override
    public void signV4(Authorization auth, Request request, Ks3ClientConfig ks3config) {
        try {
            Ks3V4Signer signer = new Ks3V4Signer();
            if (!request.isPresign()) {
                if (auth.getSecurityToken() != null) {
                    request.addHeader(HttpHeaders.XKssSecurityTokenHeader.toString(), auth.getSecurityToken());
                }
                signer.sign(auth, request, ks3config);
            } else {
                if (auth.getSecurityToken() != null) {
                    request.getQueryParams().put("security-token", auth.getSecurityToken());
                }
                String signature = signer.calcSignature(auth, request, ks3config);
                request.addQueryParam("X-Kss-Signature", signature);
            }
        }
        catch (Exception e) {
            throw new Ks3ClientException("\u8ba1\u7b97\u7528\u6237\u7b7e\u540d\u65f6\u51fa\u9519(" + e + ")", e);
        }
    }
}

