/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.signer.internal;

import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.signer.SdkClock;
import com.ksyun.ks3.utils.KSS4SignerUtils;
import java.util.Date;

public final class KSSSignerRequestParams {
    private final Request request;
    private final long signingDateTimeMilli;
    private final String scope;
    private final String regionName;
    private final String serviceName;
    private final String formattedSigningDateTime;
    private final String formattedSigningDate;
    private final String signingAlgorithm;

    public KSSSignerRequestParams(Request request, Date signingDateOverride, String regionNameOverride, String serviceName, String signingAlgorithm) {
        if (request == null) {
            throw new IllegalArgumentException("Request cannot be null");
        }
        if (signingAlgorithm == null) {
            throw new IllegalArgumentException("Signing Algorithm cannot be null");
        }
        this.request = request;
        this.signingDateTimeMilli = signingDateOverride != null ? signingDateOverride.getTime() : this.getSigningDate(request);
        this.formattedSigningDate = KSS4SignerUtils.formatDateStamp(this.signingDateTimeMilli);
        this.serviceName = serviceName;
        this.regionName = regionNameOverride;
        this.scope = this.generateScope(request, this.formattedSigningDate, this.serviceName, this.regionName);
        this.formattedSigningDateTime = KSS4SignerUtils.formatTimestamp(this.signingDateTimeMilli);
        this.signingAlgorithm = signingAlgorithm;
    }

    private final long getSigningDate(Request request) {
        return SdkClock.Instance.get().currentTimeMillis() - request.getExpires().getTime();
    }

    private String generateScope(Request request, String dateStamp, String serviceName, String regionName) {
        StringBuilder scopeBuilder = new StringBuilder();
        return scopeBuilder.append(dateStamp).append("/").append(regionName).append("/").append(serviceName).append("/").append("kss4_request").toString();
    }

    public Request getRequest() {
        return this.request;
    }

    public String getScope() {
        return this.scope;
    }

    public String getFormattedSigningDateTime() {
        return this.formattedSigningDateTime;
    }

    public long getSigningDateTimeMilli() {
        return this.signingDateTimeMilli;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getFormattedSigningDate() {
        return this.formattedSigningDate;
    }

    public String getSigningAlgorithm() {
        return this.signingAlgorithm;
    }
}

