/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import shadedforhadoopks3.org.apache.http.HttpRequest;
import shadedforhadoopks3.org.apache.http.HttpResponse;

public class StringUtils {
    public static final int MIN_BUCKET_NAME_LENGTH = 3;
    public static final int MAX_BUCKET_NAME_LENGTH = 63;
    public static final int MAXIMUM_ALLOWED_ID_LENGTH = 255;
    private static final String DEFAULT_ENCODING = "UTF-8";
    public static final String COMMA_SEPARATOR = ",";
    public static final Charset UTF8 = Charset.forName("UTF-8");
    private static final char CHAR_SPACE = ' ';
    private static final char CHAR_TAB = '\t';
    private static final char CHAR_NEW_LINE = '\n';
    private static final char CHAR_VERTICAL_TAB = '\u000b';
    private static final char CHAR_CARRIAGE_RETURN = '\r';
    private static final char CHAR_FORM_FEED = '\f';
    private static final Locale LOCALE_ENGLISH = Locale.ENGLISH;
    private static List<Character> need = Arrays.asList(Character.valueOf('\\'), Character.valueOf('\"'), Character.valueOf('$'), Character.valueOf('\''));

    public static String join(Object[] strings, String spliter) {
        boolean i = false;
        StringBuffer buffer = new StringBuffer();
        for (Object s : strings) {
            if (!i) {
                buffer.append(s);
                i = true;
                continue;
            }
            buffer.append(spliter + s);
        }
        return buffer.toString();
    }

    public static String join(int[] strings, String spliter) {
        boolean i = false;
        StringBuffer buffer = new StringBuffer();
        int[] arr$ = strings;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer s = arr$[i$];
            if (!i) {
                buffer.append(s);
                i = true;
                continue;
            }
            buffer.append(spliter + s);
        }
        return buffer.toString();
    }

    public static String join(byte[] strings, String spliter) {
        boolean i = false;
        StringBuffer buffer = new StringBuffer();
        byte[] arr$ = strings;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Byte s = arr$[i$];
            if (!i) {
                buffer.append(s);
                i = true;
                continue;
            }
            buffer.append(spliter + s);
        }
        return buffer.toString();
    }

    public static String join(List<String> strings, String spliter) {
        return StringUtils.join(strings.toArray(), spliter);
    }

    public static boolean isBlank(String s) {
        if (s == null) {
            return true;
        }
        return s.trim().length() == 0;
    }

    public static String validateBucketName(String bname) {
        if (bname == null) {
            return null;
        }
        if (bname.length() < 3 || bname.length() > 63) {
            return null;
        }
        char begin = bname.charAt(0);
        if (begin < '0' || begin > '9' && begin < 'a' || begin > 'z') {
            return null;
        }
        int previous = 0;
        for (int i = 0; i < bname.length(); ++i) {
            char next = bname.charAt(i);
            if (next >= 'A' && next <= 'Z') {
                return null;
            }
            if (next == ' ' || next == '\t' || next == '\r' || next == '\n') {
                return null;
            }
            if (next == '.') {
                if (previous == 46) {
                    return null;
                }
                if (previous == 45) {
                    return null;
                }
            } else if (next == '-' ? previous == 46 : next < '0' || next > '9' && next < 'a' || next > 'z') {
                return null;
            }
            previous = next;
        }
        if (previous == 46 || previous == 45) {
            return null;
        }
        return bname;
    }

    public static String object2string(Object obj) {
        return StringUtils.object2string(0, obj, null);
    }

    private static <T> boolean serializable(T obj) {
        if (obj.getClass().getClass().toString().startsWith("com.ksyun.ks3.dto")) {
            return false;
        }
        if (obj instanceof Serializable || obj instanceof Map || obj instanceof Collection || obj instanceof InputStream) {
            return true;
        }
        if (obj.getClass().isEnum()) {
            return true;
        }
        return obj instanceof HttpRequest || obj instanceof HttpResponse;
    }

    private static String object2string(int index, Object obj, Field fieldF) {
        StringBuffer value = new StringBuffer();
        StringBuffer prefixSb = new StringBuffer();
        for (int i = 0; i < index - 1; ++i) {
            prefixSb.append("   ");
        }
        String prefix = prefixSb.toString();
        if (fieldF != null) {
            value.append(prefix + fieldF.getName() + "=" + obj.getClass() + "\n");
        } else {
            value.append(prefix + obj.getClass() + "\n");
        }
        if (index != 0) {
            prefixSb.append("   ");
        }
        prefix = prefixSb.toString();
        ArrayList<Field> fields = new ArrayList<Field>();
        Class<?> clazz = obj.getClass();
        while (!clazz.equals(Object.class)) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        HashMap<Field, Object> valuesToAdd = new HashMap<Field, Object>();
        for (int i = 0; i < fields.size(); ++i) {
            Field field = (Field)fields.get(i);
            field.setAccessible(true);
            Object fieldValue = null;
            try {
                fieldValue = field.get(obj);
            }
            catch (IllegalArgumentException e1) {
                e1.printStackTrace();
            }
            catch (IllegalAccessException e1) {
                e1.printStackTrace();
            }
            if (fieldValue != null) {
                if (StringUtils.serializable(fieldValue)) {
                    value.append(prefix + field.getName() + "=" + fieldValue.toString() + "\n");
                    continue;
                }
                valuesToAdd.put(field, fieldValue);
                continue;
            }
            if (fieldValue != null) continue;
            value.append(prefix + field.getName() + "=null" + "\n");
        }
        for (Map.Entry obj1 : valuesToAdd.entrySet()) {
            value.append(StringUtils.object2string(index + 1, obj1.getValue(), (Field)obj1.getKey()));
        }
        return value.toString();
    }

    public static boolean checkLong(Object o) {
        String value = String.valueOf(o);
        Pattern pattern = Pattern.compile("^[0-9]+$");
        Matcher matcher = pattern.matcher(value);
        return matcher.find();
    }

    public static String object2json(Object obj) {
        return StringUtils.object2json(obj, false);
    }

    private static String object2json(Object obj, boolean escape) {
        StringBuffer buffer = new StringBuffer();
        if (obj instanceof Map) {
            buffer.append("{");
            Map map = (Map)obj;
            int size = map.size();
            int count = 0;
            for (Map.Entry entry : map.entrySet()) {
                buffer.append("\"" + StringUtils.escape(entry.getKey(), false) + "\"" + ":" + StringUtils.object2json(entry.getValue(), true));
                if (count < size - 1) {
                    buffer.append(COMMA_SEPARATOR);
                }
                ++count;
            }
            buffer.append("}");
        } else if (obj instanceof Collection) {
            buffer.append("[");
            Collection collect = (Collection)obj;
            int size = collect.size();
            int count = 0;
            for (Object o : collect) {
                if (count == 2) {
                    buffer.append(StringUtils.object2json(o, true));
                } else {
                    buffer.append(StringUtils.object2json(o));
                }
                if (count < size - 1) {
                    buffer.append(COMMA_SEPARATOR);
                }
                ++count;
            }
            buffer.append("]");
        } else if (obj instanceof Number || obj instanceof Boolean) {
            buffer.append(obj.toString());
        } else if (escape) {
            buffer.append("\"" + StringUtils.escape(obj.toString(), true) + "\"");
        } else {
            buffer.append("\"" + StringUtils.escape(obj.toString(), false) + "\"");
        }
        return buffer.toString();
    }

    private static String escape(Object obj, boolean dollar) {
        String s = obj.toString();
        byte[] chars = s.getBytes();
        int count = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (!need.contains(Character.valueOf((char)chars[i])) || !dollar && (char)chars[i] == '$') continue;
            ++count;
        }
        byte[] newChars = new byte[chars.length + count];
        int j = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (need.contains(Character.valueOf((char)chars[i])) && (dollar || (char)chars[i] != '$')) {
                newChars[i + j] = 92;
                newChars[i + j + 1] = chars[i];
                ++j;
                continue;
            }
            newChars[i + j] = chars[i];
        }
        return new String(newChars);
    }

    public static String getFileName(File file) {
        String key = file.getAbsolutePath().replace("//", "/").replace("\\", "/");
        if (key.endsWith("/")) {
            key = key.substring(0, key.length() - 1);
        }
        String[] keys = key.split("/");
        key = keys[keys.length - 1];
        return key;
    }

    public static String inputStream2String(InputStream in) {
        StringBuffer out = new StringBuffer();
        byte[] b = new byte[4096];
        try {
            int n;
            while ((n = in.read(b)) != -1) {
                out.append(new String(b, 0, n));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return out.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void inputStream2File(InputStream in, File file) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        int bytesRead = 0;
        byte[] buffer = new byte[8192];
        try {
            while ((bytesRead = in.read(buffer, 0, 8192)) != -1) {
                ((OutputStream)os).write(buffer, 0, bytesRead);
            }
        }
        finally {
            try {
                ((OutputStream)os).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isNullOrEmpty(String value) {
        return value == null || value.isEmpty();
    }

    public static String lowerCase(String str) {
        if (StringUtils.isNullOrEmpty(str)) {
            return str;
        }
        return str.toLowerCase(LOCALE_ENGLISH);
    }

    public static void appendCompactedString(StringBuilder destination, String source) {
        boolean previousIsWhiteSpace = false;
        int length = source.length();
        for (int i = 0; i < length; ++i) {
            char ch = source.charAt(i);
            if (StringUtils.isWhiteSpace(ch)) {
                if (previousIsWhiteSpace) continue;
                destination.append(' ');
                previousIsWhiteSpace = true;
                continue;
            }
            destination.append(ch);
            previousIsWhiteSpace = false;
        }
    }

    private static boolean isWhiteSpace(char ch) {
        if (ch == ' ') {
            return true;
        }
        if (ch == '\t') {
            return true;
        }
        if (ch == '\n') {
            return true;
        }
        if (ch == '\u000b') {
            return true;
        }
        if (ch == '\r') {
            return true;
        }
        return ch == '\f';
    }
}

