/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import com.ksyun.kmr.hadoop.fs.ks3.committer.DirectFileOutputCommitter;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCommitter;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class Ks3FileOutputCommitter
extends OutputCommitter {
    public static final Logger LOG = LoggerFactory.getLogger((String)"org.apache.hadoop.mapred.FileOutputCommitter");
    public static final String TEMP_DIR_NAME = "_temporary";
    public static final String SUCCEEDED_FILE_NAME = "_SUCCESS";
    static final String SUCCESSFUL_JOB_OUTPUT_DIR_MARKER = "mapreduce.fileoutputcommitter.marksuccessfuljobs";
    private FileOutputCommitter wrapped = null;

    private static Path getOutputPath(org.apache.hadoop.mapred.JobContext context) {
        JobConf conf = context.getJobConf();
        return FileOutputFormat.getOutputPath((JobConf)conf);
    }

    private static Path getOutputPath(org.apache.hadoop.mapred.TaskAttemptContext context) {
        JobConf conf = context.getJobConf();
        return FileOutputFormat.getOutputPath((JobConf)conf);
    }

    private FileOutputCommitter getWrapped(org.apache.hadoop.mapred.JobContext context) throws IOException {
        if (this.wrapped == null) {
            this.wrapped = new DirectFileOutputCommitter(Ks3FileOutputCommitter.getOutputPath(context), (JobContext)context);
        }
        return this.wrapped;
    }

    private FileOutputCommitter getWrapped(org.apache.hadoop.mapred.TaskAttemptContext context) throws IOException {
        if (this.wrapped == null) {
            this.wrapped = new DirectFileOutputCommitter(Ks3FileOutputCommitter.getOutputPath(context), (TaskAttemptContext)context);
        }
        return this.wrapped;
    }

    @InterfaceAudience.Private
    Path getJobAttemptPath(org.apache.hadoop.mapred.JobContext context) {
        Path out = Ks3FileOutputCommitter.getOutputPath(context);
        return out == null ? null : FileOutputCommitter.getJobAttemptPath((JobContext)context, (Path)out);
    }

    @InterfaceAudience.Private
    public Path getTaskAttemptPath(org.apache.hadoop.mapred.TaskAttemptContext context) throws IOException {
        Path out = Ks3FileOutputCommitter.getOutputPath(context);
        return out == null ? null : this.getTaskAttemptPath(context, out);
    }

    private Path getTaskAttemptPath(org.apache.hadoop.mapred.TaskAttemptContext context, Path out) throws IOException {
        Path workPath = FileOutputFormat.getWorkOutputPath((JobConf)context.getJobConf());
        if (workPath == null && out != null) {
            return FileOutputCommitter.getTaskAttemptPath((TaskAttemptContext)context, (Path)out);
        }
        return workPath;
    }

    @InterfaceAudience.Private
    Path getCommittedTaskPath(org.apache.hadoop.mapred.TaskAttemptContext context) {
        Path out = Ks3FileOutputCommitter.getOutputPath(context);
        return out == null ? null : FileOutputCommitter.getCommittedTaskPath((TaskAttemptContext)context, (Path)out);
    }

    public Path getWorkPath(org.apache.hadoop.mapred.TaskAttemptContext context, Path outputPath) throws IOException {
        return outputPath == null ? null : this.getTaskAttemptPath(context, outputPath);
    }

    public void setupJob(org.apache.hadoop.mapred.JobContext context) throws IOException {
        this.getWrapped(context).setupJob((JobContext)context);
    }

    public void commitJob(org.apache.hadoop.mapred.JobContext context) throws IOException {
        this.getWrapped(context).commitJob((JobContext)context);
    }

    @Deprecated
    public void cleanupJob(org.apache.hadoop.mapred.JobContext context) throws IOException {
        this.getWrapped(context).cleanupJob((JobContext)context);
    }

    public void abortJob(org.apache.hadoop.mapred.JobContext context, int runState) throws IOException {
        JobStatus.State state;
        if (runState == JobStatus.State.RUNNING.getValue()) {
            state = JobStatus.State.RUNNING;
        } else if (runState == JobStatus.State.SUCCEEDED.getValue()) {
            state = JobStatus.State.SUCCEEDED;
        } else if (runState == JobStatus.State.FAILED.getValue()) {
            state = JobStatus.State.FAILED;
        } else if (runState == JobStatus.State.PREP.getValue()) {
            state = JobStatus.State.PREP;
        } else if (runState == JobStatus.State.KILLED.getValue()) {
            state = JobStatus.State.KILLED;
        } else {
            throw new IllegalArgumentException(runState + " is not a valid runState.");
        }
        this.getWrapped(context).abortJob((JobContext)context, state);
    }

    public void setupTask(org.apache.hadoop.mapred.TaskAttemptContext context) throws IOException {
        this.getWrapped(context).setupTask((TaskAttemptContext)context);
    }

    public void commitTask(org.apache.hadoop.mapred.TaskAttemptContext context) throws IOException {
        this.getWrapped(context).commitTask((TaskAttemptContext)context, this.getTaskAttemptPath(context));
    }

    public void abortTask(org.apache.hadoop.mapred.TaskAttemptContext context) throws IOException {
        this.getWrapped(context).abortTask((TaskAttemptContext)context, this.getTaskAttemptPath(context));
    }

    public boolean needsTaskCommit(org.apache.hadoop.mapred.TaskAttemptContext context) throws IOException {
        return this.getWrapped(context).needsTaskCommit((TaskAttemptContext)context, this.getTaskAttemptPath(context));
    }

    @Deprecated
    public boolean isRecoverySupported() {
        return true;
    }

    public boolean isCommitJobRepeatable(org.apache.hadoop.mapred.JobContext context) throws IOException {
        return this.getWrapped(context).isCommitJobRepeatable((JobContext)context);
    }

    public boolean isRecoverySupported(org.apache.hadoop.mapred.JobContext context) throws IOException {
        return this.getWrapped(context).isRecoverySupported((JobContext)context);
    }

    public void recoverTask(org.apache.hadoop.mapred.TaskAttemptContext context) throws IOException {
        this.getWrapped(context).recoverTask((TaskAttemptContext)context);
    }
}

