/*
 * Decompiled with CFR 0.152.
 */
package shadedforhadoopks3.com.lmax.disruptor.dsl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import shadedforhadoopks3.com.lmax.disruptor.EventHandler;
import shadedforhadoopks3.com.lmax.disruptor.EventProcessor;
import shadedforhadoopks3.com.lmax.disruptor.Sequence;
import shadedforhadoopks3.com.lmax.disruptor.SequenceBarrier;
import shadedforhadoopks3.com.lmax.disruptor.WorkerPool;
import shadedforhadoopks3.com.lmax.disruptor.dsl.ConsumerInfo;
import shadedforhadoopks3.com.lmax.disruptor.dsl.EventProcessorInfo;
import shadedforhadoopks3.com.lmax.disruptor.dsl.WorkerPoolInfo;

class ConsumerRepository<T>
implements Iterable<ConsumerInfo> {
    private final Map<EventHandler<?>, EventProcessorInfo<T>> eventProcessorInfoByEventHandler = new IdentityHashMap();
    private final Map<Sequence, ConsumerInfo> eventProcessorInfoBySequence = new IdentityHashMap<Sequence, ConsumerInfo>();
    private final Collection<ConsumerInfo> consumerInfos = new ArrayList<ConsumerInfo>();

    ConsumerRepository() {
    }

    public void add(EventProcessor eventprocessor, EventHandler<? super T> handler, SequenceBarrier barrier) {
        EventProcessorInfo<? super T> consumerInfo = new EventProcessorInfo<T>(eventprocessor, handler, barrier);
        this.eventProcessorInfoByEventHandler.put(handler, consumerInfo);
        this.eventProcessorInfoBySequence.put(eventprocessor.getSequence(), consumerInfo);
        this.consumerInfos.add(consumerInfo);
    }

    public void add(EventProcessor processor) {
        EventProcessorInfo consumerInfo = new EventProcessorInfo(processor, null, null);
        this.eventProcessorInfoBySequence.put(processor.getSequence(), consumerInfo);
        this.consumerInfos.add(consumerInfo);
    }

    public void add(WorkerPool<T> workerPool, SequenceBarrier sequenceBarrier) {
        WorkerPoolInfo<T> workerPoolInfo = new WorkerPoolInfo<T>(workerPool, sequenceBarrier);
        this.consumerInfos.add(workerPoolInfo);
        for (Sequence sequence : workerPool.getWorkerSequences()) {
            this.eventProcessorInfoBySequence.put(sequence, workerPoolInfo);
        }
    }

    public Sequence[] getLastSequenceInChain(boolean includeStopped) {
        ArrayList lastSequence = new ArrayList();
        for (ConsumerInfo consumerInfo : this.consumerInfos) {
            if (!includeStopped && !consumerInfo.isRunning() || !consumerInfo.isEndOfChain()) continue;
            Sequence[] sequences = consumerInfo.getSequences();
            Collections.addAll(lastSequence, sequences);
        }
        return lastSequence.toArray(new Sequence[lastSequence.size()]);
    }

    public EventProcessor getEventProcessorFor(EventHandler<T> handler) {
        EventProcessorInfo<T> eventprocessorInfo = this.getEventProcessorInfo(handler);
        if (eventprocessorInfo == null) {
            throw new IllegalArgumentException("The event handler " + handler + " is not processing events.");
        }
        return eventprocessorInfo.getEventProcessor();
    }

    public Sequence getSequenceFor(EventHandler<T> handler) {
        return this.getEventProcessorFor(handler).getSequence();
    }

    public void unMarkEventProcessorsAsEndOfChain(Sequence ... barrierEventProcessors) {
        for (Sequence barrierEventProcessor : barrierEventProcessors) {
            this.getEventProcessorInfo(barrierEventProcessor).markAsUsedInBarrier();
        }
    }

    @Override
    public Iterator<ConsumerInfo> iterator() {
        return this.consumerInfos.iterator();
    }

    public SequenceBarrier getBarrierFor(EventHandler<T> handler) {
        EventProcessorInfo<T> consumerInfo = this.getEventProcessorInfo(handler);
        return consumerInfo != null ? consumerInfo.getBarrier() : null;
    }

    private EventProcessorInfo<T> getEventProcessorInfo(EventHandler<T> handler) {
        return this.eventProcessorInfoByEventHandler.get(handler);
    }

    private ConsumerInfo getEventProcessorInfo(Sequence barrierEventProcessor) {
        return this.eventProcessorInfoBySequence.get(barrierEventProcessor);
    }
}

