/*
 * Decompiled with CFR 0.152.
 */
package shadedforhadoopks3.org.apache.http.impl.client;

import shadedforhadoopks3.org.apache.http.HttpResponse;
import shadedforhadoopks3.org.apache.http.annotation.Immutable;
import shadedforhadoopks3.org.apache.http.client.ServiceUnavailableRetryStrategy;
import shadedforhadoopks3.org.apache.http.protocol.HttpContext;
import shadedforhadoopks3.org.apache.http.util.Args;

@Immutable
public class DefaultServiceUnavailableRetryStrategy
implements ServiceUnavailableRetryStrategy {
    private final int maxRetries;
    private final long retryInterval;

    public DefaultServiceUnavailableRetryStrategy(int maxRetries, int retryInterval) {
        Args.positive(maxRetries, "Max retries");
        Args.positive(retryInterval, "Retry interval");
        this.maxRetries = maxRetries;
        this.retryInterval = retryInterval;
    }

    public DefaultServiceUnavailableRetryStrategy() {
        this(1, 1000);
    }

    @Override
    public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
        return executionCount <= this.maxRetries && response.getStatusLine().getStatusCode() == 503;
    }

    @Override
    public long getRetryInterval() {
        return this.retryInterval;
    }
}

