package com.ksyun.ks3.service.request;

import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.utils.StringUtils;
import static com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator.notNull;

/**
 * <p>
 * 获取桶镜像配置。
 * </p>
 * 
 * @author huanghaixin
 * @version 1.0 2021年3月9日
 */
public class GetBucketMirrorRequest extends Ks3WebServiceRequest {
    private String bucketName;

    public GetBucketMirrorRequest() {
    }

    public GetBucketMirrorRequest(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public void validateParams() {
        if (StringUtils.isBlank(this.bucketName))
            throw notNull("bucketName");
    }

    public void buildRequest(Request request) {
        request.setMethod(HttpMethod.GET);
        request.setBucket(bucketName);
        request.getQueryParams().put("mirror", "");
    }

}