package com.ksyun.ks3.service.request;

import com.ksyun.ks3.dto.ReplicationRule;
import com.ksyun.ks3.http.HttpHeaders;
import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.utils.Md5Utils;
import com.ksyun.ks3.utils.StringUtils;
import com.ksyun.ks3.utils.XmlWriter;

import java.io.ByteArrayInputStream;
import java.util.List;

import static com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator.notNull;
import static com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator.notCorrect;

public class PutBucketReplicationConfigurationRequest extends Ks3WebServiceRequest{
    private String bucketName;
    private ReplicationRule replicationRule;

    public PutBucketReplicationConfigurationRequest() {
    }

    public PutBucketReplicationConfigurationRequest(String bucketName, ReplicationRule replicationRule) {
        this.bucketName = bucketName;
        this.replicationRule = replicationRule;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }


    public ReplicationRule getReplicationRule() {
        return replicationRule;
    }

    public void setReplicationRule(ReplicationRule replicationRule) {
        this.replicationRule = replicationRule;
    }

    public void validateParams() {
        if (StringUtils.isBlank(this.bucketName))
            throw notNull("bucketName");
        if (this.replicationRule == null)
            throw notNull("replicationRule");
        if (this.replicationRule.getTargetBucket() == null)
            throw notNull("targetBucket");
        if (this.replicationRule.getPrefixList().size() > 5)
            throw notCorrect("prefixList",this.replicationRule.getPrefixList().toString(),"prefixList too many");
    }

    public void buildRequest(Request request) {
        request.setMethod(HttpMethod.PUT);
        request.setBucket(bucketName);
        request.addQueryParam("crr","");
        XmlWriter writer = new XmlWriter();
        writer.startWithNs("Replication");
        for(String prefix: replicationRule.getPrefixList()){
            writer.start("prefix").value(prefix).end();
        }
        if (replicationRule.isDeleteMarkerStatus())
            writer.start("DeleteMarkerStatus").value(ReplicationRule.ENABLED).end();
        else
            writer.start("DeleteMarkerStatus").value(ReplicationRule.DISABLED).end();
        writer.start("targetBucket").value(replicationRule.getTargetBucket()).end();
        writer.end();
        String xml = writer.toString();

        request.addHeader(HttpHeaders.ContentMD5, Md5Utils.md5AsBase64(xml.getBytes()));
        request.setContent(new ByteArrayInputStream(xml.getBytes()));
    }

}
