
package com.ksyun.ks3.utils;



import com.ksyun.ks3.annotation.Immutable;

import java.io.Serializable;

@Immutable
class BasicNameValuePair implements NameValuePair, Cloneable, Serializable {
    private static final long serialVersionUID = 1L;
    public static final int HASH_SEED = 17;
    public static final int HASH_OFFSET = 37;

    private final String name;
    private final String value;

    /**
     * Default Constructor taking a name and a value. The value may be null.
     *
     * @param name The name.
     * @param value The value.
     */
    BasicNameValuePair(final String name, final String value) {
        if (name == null)
            throw new IllegalArgumentException("Name must not be null");
        this.name = name;
        this.value = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        // don't call complex default formatting for a simple toString

        if (this.value == null) {
            return name;
        }
        final int len = this.name.length() + 1 + this.value.length();
        final StringBuilder buffer = new StringBuilder(len);
        buffer.append(this.name);
        buffer.append("=");
        buffer.append(this.value);
        return buffer.toString();
    }

    @Override
    public boolean equals(final Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof NameValuePair) {
            final BasicNameValuePair that = (BasicNameValuePair) object;
            return this.name.equals(that.name)
                  && equals(this.value, that.value);
        }
        return false;
    }

    private static boolean equals(final Object obj1, final Object obj2) {
        return obj1 == null ? obj2 == null : obj1.equals(obj2);
    }

    @Override
    public int hashCode() {
        int hash = HASH_SEED;
        hash = hashCode(hash, this.name);
        hash = hashCode(hash, this.value);
        return hash;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private static int hashCode(final int seed, final Object obj) {
        return hashCode(seed, obj != null ? obj.hashCode() : 0);
    }

    private static int hashCode(final int seed, final int hashcode) {
        return seed * HASH_OFFSET + hashcode;
    }
}
