
package com.ksyun.ks3.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Target;

/**
 * Marker interface for methods used by test code in the same module. Methods/Constructors annotated
 * with this method should not be accessed in production code. This annotation should be used
 * sparingly as it's a code smell to need access to internal data/functionality to properly unit
 * test a class. Typically there is a better way to test a class.
 * <p>
 * TODO: Write a linter that makes sure only test code depends on methods or constructors annotated
 * with this method
 */
@Target({ ElementType.CONSTRUCTOR, ElementType.METHOD, ElementType.FIELD })
public @interface SdkTestInternalApi {
}
