package com.ksyun.ks3.dto;

public class BucketRetentionConfiguration {

    private Rule rule;

    public BucketRetentionConfiguration() {
    }

    public BucketRetentionConfiguration(Rule rule) {
        this.rule = rule;
    }

    public Rule getRule() {
        return rule;
    }

    public void setRule(Rule rule) {
        this.rule = rule;
    }

    public BucketRetentionConfiguration withRule(Rule rule) {
        setRule(rule);
        return this;
    }

    public String toString() {
        return "BucketRetentionConfiguration(rule=" + getRule() + ")";
    }

    public static class Rule {
        private Status status;
        private int days = -1;

        public Rule() {
        }

        public Rule(Status status, int days) {
            this.status = status;
            this.days = days;
        }

        public Status getStatus() {
            return status;
        }

        public void setStatus(Status status) {
            this.status = status;
        }

        public Rule withStatus(Status status) {
            setStatus(status);
            return this;
        }

        public int getDays() {
            return days;
        }

        public void setDays(int days) {
            this.days = days;
        }

        public Rule withDays(int days) {
            setDays(days);
            return this;
        }
    }

    public static enum Status {
        ENABLED("Enabled"),
        DISABLED("Disabled");

        private Status(String status) {
            this.status = status;
        }

        private final String status;

        public String status2Str() {
            return status;
        }

        public static Status str2Status(String statusStr) {
            Status status = null;
            for (Status senum : Status.values()) {
                if (senum.status.equals(statusStr)) {
                    status = senum;
                    break;
                }
            }
            return status;
        }
    }
}