package com.ksyun.ks3.dto;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.ksyun.ks3.exception.Ks3ClientException;

import java.io.IOException;

/**
 * 图片持久化
 */
public class ProcessObjectResult {
	private Long fileSize;
	private String status;
	private String bucket;
	private String object;



	public void setFileSize(Long fileSize) {
		this.fileSize = fileSize;
	}
	public Long getFileSize() {
		return fileSize;
	}

	public void setStatus(String status) {
		this.status = status;
	}
	public String getStatus() {
		return status;
	}

	public void setBucket(String bucket) {
		this.bucket = bucket;
	}
	public String getBucket() {
		return bucket;
	}

	public void setObject(String object) {
		this.object = object;
	}
	public String getObject() {
		return object;
	}
	public static ProcessObjectResult fromJson(String jsonText) {
		try {
			ObjectMapper objectMapper = new ObjectMapper();
			return objectMapper.readValue(jsonText, ProcessObjectResult.class);
		} catch (IOException e) {
			throw new Ks3ClientException("failed to deserialize ImgSaveAsResult from json text", e);
		}
	}
}
