package com.ksyun.ks3.dto;

import com.ksyun.ks3.utils.StringUtils;

import java.util.ArrayList;
import java.util.List;


/**
 * @author yanghui4
 * @date 2023-09-21
 * @description List Retention objects 的返回结果
 */
public class RetentionObjectListing extends Ks3Result {
    private List<RetentionObject> retentionObjects = new ArrayList<>();

    private String bucketName;
    /**
     * 若isTruncated为true,则nextMarker可以作为下次请求的marker
     */
    private String nextMarker;
    /**
     * 如果结果被全部列出来则为false
     */
    private boolean isTruncated;
    private String prefix;
    /**
     * 即游标，将列出排在游标之后的object
     */
    private String marker;
    private int maxKeys;
    private String delimiter;
    /**
     * ks3服务器对返回的xml中object key的编码方式
     */
    private String encodingType;

    @Override
    public String toString() {
        return StringUtils.object2string(this);
    }

    public List<RetentionObject> getRetentionObjects() {
        return retentionObjects;
    }

    public void setRetentionObjects(List<RetentionObject> objs) {
        this.retentionObjects = objs;
    }

    /**
     * 即游标，将列出排在游标之后的object
     */
    public String getNextMarker() {
        return nextMarker;
    }

    public void setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
    }

    public String getBucketName() {
        return bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getPrefix() {
        return prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getMarker() {
        return marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public int getMaxKeys() {
        return maxKeys;
    }

    public void setMaxKeys(int maxKeys) {
        this.maxKeys = maxKeys;
    }

    public String getDelimiter() {
        return delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    /**
     * isTruncated为true时表示之后还有object
     */
    public boolean isTruncated() {
        return isTruncated;
    }

    public void setTruncated(boolean isTruncated) {
        this.isTruncated = isTruncated;
    }

    public String getEncodingType() {
        return encodingType;
    }

    public void setEncodingType(String encodingType) {
        this.encodingType = encodingType;
    }

}
