package com.ksyun.ks3.service.common;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public enum BucketType {

    /**
     * 极速存储类型
     */
    EXTREME_PL1("EXTREME_PL1"),
    EXTREME_PL2("EXTREME_PL2"),
    EXTREME_PL3("EXTREME_PL3"),

    /**
     * 默认的KS3存储类型。Standard 提供较高的持久性、可用性和性能对象存储。
     */
    Normal("NORMAL"),

    /**
     * 低频存储桶类型
     */
    IA("IA"),

    /**
     * 用于不频繁访问但在需要时也要求快速访问的数据。Standard – IA 提供较高的持久性、吞吐量和较低的延迟
     */
    Archive("ARCHIVE"),

    /**
     * 未知类型，当ks3有新的类型，而本SDK暂不支持时，返回该未知类型
     */
    UNKNOWN("UNKNOWN"),
    ;

    private static final Log log = LogFactory.getLog(BucketType.class);

    public static BucketType fromValue(String typeString) throws IllegalArgumentException {
        for (BucketType type : BucketType.values()) {
            if (type.toString().equals(typeString)) {
                return type;
            }
        }
        log.warn("unknown bucket type: " + typeString + ", use " + UNKNOWN + " instead");
        return UNKNOWN;
    }

    private final String typeId;

    private BucketType(String id) {
        this.typeId = id;
    }

    @Override
    public String toString() {
        return typeId;
    }
}
