package com.ksyun.ks3.service.common;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author qichao[qichao@kingsoft.com]  
 * @date 2016年3月1日 下午5:30:30
 * @description 存储类型枚举
 **/
public enum StorageClass {

    /**
     * 极速存储类型
     */
    EXTREME_PL1("EXTREME_PL1"),
    EXTREME_PL2("EXTREME_PL2"),
    EXTREME_PL3("EXTREME_PL3"),

    /**
     * 默认的KS3存储类型。Standard 提供较高的持久性、可用性和性能对象存储。
     */
    Standard("STANDARD"),

    /**
     * 用于不频繁访问但在需要时也要求快速访问的数据。Standard – IA 提供较高的持久性、吞吐量和较低的延迟
     */
    StandardInfrequentAccess("STANDARD_IA"),

    /**
     * 归档存储类型
     */
	Archive("ARCHIVE"),

    /**
     * 未知类型，当ks3有新的类型，而本SDK暂不支持时，返回该未知类型
     */
    UNKNOWN("UNKNOWN"),
    ;

    private static final Log log = LogFactory.getLog(StorageClass.class);

    public static StorageClass fromValue(String s3StorageClassString) throws IllegalArgumentException {
        for (StorageClass storageClass : StorageClass.values()) {
            if (storageClass.toString().equals(s3StorageClassString)) {
                return storageClass;
            }
        }
        log.warn("unknown storage class: " + s3StorageClassString + ", use " + UNKNOWN + " instead");
        return UNKNOWN;
    }

    private final String storageClassId;

    private StorageClass(String id) {
        this.storageClassId = id;
    }

    @Override
    public String toString() {
        return storageClassId;
    }
}
