package com.ksyun.ks3.service.encryption;

import com.ksyun.ks3.dto.*;
import com.ksyun.ks3.service.request.*;

/**
 * Used to provide direct access to the underlying/original S3 client methods
 * free of any added cryptographic functionalities.
 */
public abstract class S3Direct {
    public abstract PutObjectResult putObject(PutObjectRequest req);

    public abstract GetObjectResult getObject(GetObjectRequest req);

    public abstract CompleteMultipartUploadResult completeMultipartUpload(
            CompleteMultipartUploadRequest req);

    public abstract InitiateMultipartUploadResult initiateMultipartUpload(
            InitiateMultipartUploadRequest req);

    public abstract PartETag uploadPart(UploadPartRequest req);

    public abstract CopyResult copyPart(CopyPartRequest req);

    public abstract void abortMultipartUpload(AbortMultipartUploadRequest req);
}