package com.ksyun.ks3.service.encryption.model;

import com.ksyun.ks3.dto.ObjectMetadata;
import com.ksyun.ks3.service.Ks3Client;
import com.ksyun.ks3.service.encryption.Ks3EncryptionClient;
import com.ksyun.ks3.service.request.InitiateMultipartUploadRequest;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/** 
 * <p>
 * This class is an extension of {@link InitiateMultipartUploadRequest} to allow additional 
 * encryption material description to be specified on a per-request basis.
 * In particular, {@link EncryptedInitiateMultipartUploadRequest} is only recognized by {@link Ks3EncryptionClient}.
 * </p> 
 * <p>
 * If {@link EncryptedInitiateMultipartUploadRequest} is used against the non-encrypting {@link Ks3Client},
 * these additional attributes will be ignored.
 * </p>
 */

public class EncryptedInitiateMultipartUploadRequest extends InitiateMultipartUploadRequest implements MaterialsDescriptionProvider {

    /**
     * description of encryption materials to be used with this request.
     */
    private Map<String, String> materialsDescription;
    
    public EncryptedInitiateMultipartUploadRequest(String bucketName, String key) {
        super(bucketName, key);
    }
    
    public EncryptedInitiateMultipartUploadRequest(String bucketName, String key, ObjectMetadata objectMetadata) {
        super(bucketName, key, objectMetadata);
    }
    
    public Map<String, String> getMaterialsDescription() {
        return materialsDescription;
    }
    
    /**
     * sets the materials description for the encryption materials to be used with the current Multi Part Upload Request.
     * @param materialsDescription the materialsDescription to set
     */
    public void setMaterialsDescription(Map<String, String> materialsDescription) {
        this.materialsDescription = materialsDescription == null
                ? null 
                : Collections.unmodifiableMap(new HashMap<String,String>(materialsDescription))
                ;
    }
    
    /**
     * sets the materials description for the encryption materials to be used with the current Multi Part Upload Request.
     * @param materialsDescription the materialsDescription to set
     */
    public EncryptedInitiateMultipartUploadRequest withMaterialsDescription(Map<String, String> materialsDescription) {
        setMaterialsDescription(materialsDescription);
        return this;
    }
}
