package com.ksyun.ks3.service.request;

import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.utils.StringUtils;

import static com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator.notNull;

public class DeleteObjectTaggingRequest extends Ks3WebServiceRequest {
	private String bucketName;

	private String objectName;

	public DeleteObjectTaggingRequest(String bucketName, String objectName) {
		this.bucketName = bucketName;
		this.objectName = objectName;
	}

	public String getBucketName() {
		return this.bucketName;
	}

	public void setBucketName(String bucketName) {
		this.bucketName = bucketName;
	}

	public String getObjectName() {
		return objectName;
	}

	public void setObjectName(String objectName) {
		this.objectName = objectName;
	}

	@Override
	public void buildRequest(Request request) {
		request.setMethod(HttpMethod.DELETE);
		request.setBucket(bucketName);
		request.setKey(objectName);
		request.addQueryParam("tagging","");

	}

	@Override
	public void validateParams() {
		if(StringUtils.isBlank(this.bucketName))
			throw notNull("bucketName");

		if(StringUtils.isBlank(this.objectName))
			throw notNull("objectName");
	}
	
}