package com.ksyun.ks3.service.request;

import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.utils.StringUtils;
import static com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator.notNull;


/**
 *
 * @date 2020年05月18日 下午1:46:05
 *
 * @description 获取bucket的跨区域复制配置
 **/
public class GetBucketReplicationConfigurationRequest extends Ks3WebServiceRequest {
    private String bucketName;

    public GetBucketReplicationConfigurationRequest() {
    }

    public GetBucketReplicationConfigurationRequest(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }


    public void validateParams() {
        if (StringUtils.isBlank(this.bucketName))
            throw notNull("bucketName");
    }

    public void buildRequest(Request request) {
        request.setMethod(HttpMethod.GET);
        request.setBucket(bucketName);
        request.getQueryParams().put("crr","");
    }

}