package com.ksyun.ks3.service.request;

import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Request;

/**
 * @author yanghui4
 * @date 2023-09-21
 */
public class ListRetentionObjectsRequest extends ListObjectsRequest {


    public ListRetentionObjectsRequest(String bucketName) {
        super(bucketName);
    }

    public ListRetentionObjectsRequest(String bucketName, String prefix) {
        super(bucketName, prefix);
    }

    public ListRetentionObjectsRequest(String bucketName, String prefix, String marker, String delimiter, Integer maxKeys) {
        super(bucketName, prefix, marker, delimiter, maxKeys);
    }

    @Override
    public void buildRequest(Request request) {
        request.setMethod(HttpMethod.GET);
        request.setBucket(getBucket());
        request.addQueryParam("recycle", "");
        request.addQueryParamIfNotNull("prefix", getPrefix());
        request.addQueryParamIfNotNull("marker", getMarker());
        request.addQueryParamIfNotNull("delimiter", getDelimiter());
        if (getMaxKeys() != null)
            request.addQueryParamIfNotNull("max-keys", String.valueOf(getMaxKeys()));
        request.addQueryParamIfNotNull("encoding-type", this.getEncodingType());
    }
}
