package com.ksyun.ks3.service.request;

import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.utils.StringUtils;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;

import static com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator.notNull;

/**
 * 图片持久化
 */
public class ProcessObjectRequest extends Ks3WebServiceRequest{
	private static final String XKSSPROCESS = "x-kss-process";
	private String bucket;
	private String key;
	// 图片处理参数
	private String process;

	public String getProcess() {
		return process;
	}

	public void setProcess(String process) {
		this.process = process;
	}

	public String getBucket() {
		return bucket;
	}

	public void setBucket(String bucket) {
		this.bucket = bucket;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}



	@Override
	public void validateParams() throws IllegalArgumentException {
    	if(StringUtils.isBlank(this.bucket)){
    		throw notNull("bucketname");
    	}
    	if(StringUtils.isBlank(this.key)){
    		throw notNull("objectkey");
    	}
		if(StringUtils.isBlank(this.process)){
			throw notNull("process");
		}

    }

	public ProcessObjectRequest(String bucket, String key, String process) {
		this.bucket = bucket;
		this.key = key;
		this.process = process;
	}

	@Override
	public void buildRequest(Request request){
		request.setMethod(HttpMethod.POST);
		request.setBucket(bucket);
		request.setKey(key);
		request.addQueryParam(XKSSPROCESS, "");
		String xKssProcess = XKSSPROCESS + "=" + getProcess();
		request.setContent(new ByteArrayInputStream(xKssProcess.getBytes(StandardCharsets.UTF_8)));
	}
}
