package com.ksyun.ks3.service.request;

import static com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator.notNull;

import java.io.ByteArrayInputStream;

import com.ksyun.ks3.dto.BucketMirror;
import com.ksyun.ks3.http.HttpHeaders;
import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.utils.Md5Utils;
import com.ksyun.ks3.utils.StringUtils;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.entity.ContentType;

/**
 * <p>
 * 新增或者更新桶镜像配置的请求实体类.
 * </p>
 * 
 * @author huanghaixin
 * @version 1.0 3/8/2021
 */
public class PutBucketMirrorRequest extends Ks3WebServiceRequest {
    private static final Log log = LogFactory.getLog(PutBucketMirrorRequest.class);
    private String bucketName;
    private BucketMirror bucketMirror;

    public PutBucketMirrorRequest() {

    }

    /**
     * @param bucketName
     * @param bucketMirror
     */
    public PutBucketMirrorRequest(String bucketName, BucketMirror bucketMirror) {
        this.bucketName = bucketName;
        this.bucketMirror = bucketMirror;
    }

    @Override
    public void buildRequest(Request request) {
        request.setMethod(HttpMethod.PUT);
        request.setBucket(bucketName);
        request.addQueryParam("mirror", "");

        String json = this.bucketMirror.toJson();
        log.debug("bucketmirror json:" + json);
        request.addHeader(HttpHeaders.ContentMD5, Md5Utils.md5AsBase64(json.getBytes()));
        request.addHeader(HttpHeaders.ContentType, ContentType.APPLICATION_JSON.toString());
        request.setContent(new ByteArrayInputStream(json.getBytes()));
    }

    @Override
    public void validateParams() {
        if (StringUtils.isBlank(this.bucketName)) {
            throw notNull("bucketName");
        }
        if (this.bucketMirror == null) {
            throw notNull("bucketMirror");
        }
    }

}
