package com.ksyun.ks3.service.request;

import com.ksyun.ks3.config.Constants;
import com.ksyun.ks3.dto.BucketRetentionConfiguration;
import com.ksyun.ks3.http.HttpHeaders;
import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.utils.Md5Utils;
import com.ksyun.ks3.utils.StringUtils;
import com.ksyun.ks3.utils.XmlWriter;

import java.io.ByteArrayInputStream;

import static com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator.between;
import static com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator.notNull;

public class PutBucketRetentionRequest extends Ks3WebServiceRequest {
    private String bucketName;
    private BucketRetentionConfiguration retentionConfiguration;

    public PutBucketRetentionRequest() {

    }

    public PutBucketRetentionRequest(String bucketName, BucketRetentionConfiguration retentionConfiguration) {
        this.bucketName = bucketName;
        this.retentionConfiguration = retentionConfiguration;
    }

    public String getBucketName() {
        return bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public PutBucketRetentionRequest withBucketName(String bucketName) {
        setBucketName(bucketName);
        return this;
    }

    public BucketRetentionConfiguration getRetentionConfiguration() {
        return retentionConfiguration;
    }

    public void setRetentionConfiguration(BucketRetentionConfiguration retentionConfiguration) {
        this.retentionConfiguration = retentionConfiguration;
    }

    public PutBucketRetentionRequest withRetentionConfiguration(BucketRetentionConfiguration retentionConfiguration) {
        setRetentionConfiguration(retentionConfiguration);
        return this;
    }

    @Override
    public void buildRequest(Request request) {
        request.setMethod(HttpMethod.PUT);
        request.setBucket(this.bucketName);
        request.addQueryParam("retention", "");
        XmlWriter writer = new XmlWriter();
        writer.start("RetentionConfiguration");
        writer.start("Rule");
        BucketRetentionConfiguration.Rule rule = getRetentionConfiguration().getRule();
        writer.start("Status").value(rule.getStatus().status2Str()).end();
        if (rule.getDays() != -1) {
            writer.start("Days").value(rule.getDays()).end();
        }
        writer.end();
        writer.end();
        String xml = writer.toString();
        request.addHeader(HttpHeaders.ContentMD5, Md5Utils.md5AsBase64(xml.getBytes()));
        request.setContent(new ByteArrayInputStream(xml.getBytes()));
    }

    @Override
    public void validateParams() {
        if (StringUtils.isBlank(this.bucketName)) {
            throw notNull("bucketName");
        }
        if (getRetentionConfiguration() == null) {
            throw notNull("retentionConfiguration");
        }
        if (getRetentionConfiguration().getRule() == null) {
            throw notNull("retentionConfiguration.rule");
        }
        if (getRetentionConfiguration().getRule().getDays() != -1) {
            if(getRetentionConfiguration().getRule().getDays() > 365 || getRetentionConfiguration().getRule().getDays() < 1)
                throw between("retentionConfiguration.rule.days",String.valueOf(getRetentionConfiguration().getRule().getDays()),"1",String.valueOf("365"));
        }
    }
}
