package com.ksyun.ks3.service.request;

import com.ksyun.ks3.http.HttpHeaders;
import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.utils.StringUtils;

import static com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator.notNull;

public class RecoverObjectRequest extends Ks3WebServiceRequest {
    private String bucketName;
    private String objectKey;
    private String retentionId;
    private Boolean overwrite;

    public RecoverObjectRequest() {

    }

    public RecoverObjectRequest(String bucketName, String objectKey) {
        this.bucketName = bucketName;
        this.objectKey = objectKey;
    }

    public RecoverObjectRequest(String bucketName, String objectKey, String retentionId) {
        this.bucketName = bucketName;
        this.objectKey = objectKey;
        this.retentionId = retentionId;
    }

    public String getBucketName() {
        return bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public RecoverObjectRequest withBucketName(String bucketName) {
        setBucketName(bucketName);
        return this;
    }

    public String getObjectKey() {
        return objectKey;
    }

    public void setObjectKey(String objectKey) {
        this.objectKey = objectKey;
    }

    public RecoverObjectRequest withObjectKey(String objectKey) {
        setObjectKey(objectKey);
        return this;
    }

    public String getRetentionId() {
        return retentionId;
    }

    public void setRetentionId(String retentionId) {
        this.retentionId = retentionId;
    }

    public RecoverObjectRequest withRetentionId(String retentionId) {
        this.retentionId = retentionId;
        return this;
    }

    public Boolean getOverwrite() {
        return overwrite;
    }

    public void setOverwrite(Boolean overwrite) {
        this.overwrite = overwrite;
    }

    public RecoverObjectRequest withOverwrite(boolean overwrite) {
        setOverwrite(overwrite);
        return this;
    }

    @Override
    public void buildRequest(Request request) {
        request.setMethod(HttpMethod.POST);
        request.setBucket(this.bucketName);
        request.setKey(this.objectKey);
        request.addQueryParam("recover", "");
        if (!StringUtils.isBlank(retentionId)) {
            request.addHeader(HttpHeaders.RetentionId, retentionId);
        }
        if (getOverwrite() != null) {
            request.addHeader(HttpHeaders.RetentionOverwrite, String.valueOf(getOverwrite()));
        }
    }

    @Override
    public void validateParams() {
        if (StringUtils.isBlank(this.bucketName)) {
            throw notNull("bucketName");
        }
        if (StringUtils.isBlank(this.objectKey)) {
            throw notNull("objectKey");
        }
    }
}
