package com.ksyun.ks3.service.response;

import java.io.IOException;

import com.ksyun.ks3.dto.BucketMirror;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ParseException;
import org.apache.http.util.EntityUtils;

/**
 * <p>
 * </p>
 * 
 * @author huanghaixin
 * @version 1.0 3/8/2021
 */
public class GetBucketMirrorResponse extends Ks3WebServiceDefaultResponse<BucketMirror> {
    private static final Log log = LogFactory.getLog(PutBucketMirrorResponse.class);

    @Override
    public void preHandle() {
        try {
            String jsonText = EntityUtils.toString(super.getHttpResponse().getEntity());
            log.debug("returned bucketmirror json:" + jsonText);
            this.result = BucketMirror.fromJson(jsonText);
        } catch (ParseException | IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int[] expectedStatus() {
        return new int[] { 200 };
    }

}
