package com.ksyun.ks3.service.response;

import com.ksyun.ks3.dto.ReplicationRule;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

import java.util.ArrayList;
import java.util.List;

public class GetBucketReplicationConfigurationResponse  extends Ks3WebServiceXmlResponse<ReplicationRule> {
    private List<String> prefixList = new ArrayList<String>();
    private String targetBucket;
    private boolean deleteMarkerStatus;
    private Boolean historicalObjectReplication;
    private String region;

    public int[] expectedStatus() {
        return new int[]{200};
    }

    @Override
    public void preHandle() {
        // TODO Auto-generated method stub
    }

    public void startDocument() throws SAXException {
        result = new ReplicationRule();

    }

    public void startEle(String uri, String localName, String qName, Attributes attributes) throws SAXException {

    }

    public void endEle(String uri, String localName, String qName) throws SAXException {
        if("Replication".equals(getTag())) {
            result.setTargetBucket(targetBucket);
            result.setRegion(region);
            result.setPrefixList(prefixList);
            result.setDeleteMarkerStatus(deleteMarkerStatus);
            result.setHistoricalObjectReplication(historicalObjectReplication);
        }
    }

    @Override
    public void string(String s) {
        if ("prefix".equals(getTag())) {
            prefixList.add(s);
        } else if ("targetBucket".equals(getTag())) {
            targetBucket = s;
        } else if ("DeleteMarkerStatus".equals(getTag())) {
            deleteMarkerStatus = ReplicationRule.ENABLED.equals(s);
        } else if ("HistoricalObjectReplication".equalsIgnoreCase(getTag())) {
            historicalObjectReplication = ReplicationRule.ENABLED.equals(s);
        } else if ("Region".equalsIgnoreCase(getTag())) {
            region = s;
        }
    }

}
