package com.ksyun.ks3.service.response;

import com.ksyun.ks3.dto.ObjectTag;
import com.ksyun.ks3.dto.ObjectTagging;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

import java.util.ArrayList;
import java.util.List;


public class GetObjectTaggingResponse extends
		Ks3WebServiceXmlResponse<ObjectTagging> {

	private ObjectTag tagging = null;
	private List<ObjectTag> tagSet;

	@Override
	public void startDocument() throws SAXException {
		result = new ObjectTagging();
	}

	@Override
	public void startEle(String uri, String localName, String qName,
			Attributes attributes) throws SAXException {
		String tag = getTag();
		if ("TagSet".equals(tag)) {
			tagSet = new ArrayList<ObjectTag>();
		}else if ("Tag".equals(tag)){
			tagging = new ObjectTag();
		}
	}

	@Override
	public void endEle(String uri, String localName, String qName)
			throws SAXException {
		String tag = getTag();
		if ("Tag".equals(tag)) {
			if(tagging != null){
				tagSet.add(tagging);
			}
		} else if ("Tagging".equals(tag)) {
			result.setTagSet(tagSet);
		}
	}

	@Override
	public void string(String s) {
		String tag = getTag();
		if ("Tag".equals(getTag(1))) {
			if ("Key".equals(tag)) {
				tagging.setKey(s);
			} else if ("Value".equals(tag)) {
				tagging.setValue(s);
			}
		}
	}

	@Override
	public void preHandle() {

	}

	public int[] expectedStatus() {
		return new int[] { 200 };
	}
}
