package com.ksyun.ks3.service.response;

import com.ksyun.ks3.dto.ProcessObjectResult;
import com.ksyun.ks3.exception.Ks3ClientException;
import org.apache.http.ParseException;
import org.apache.http.util.EntityUtils;

import java.io.IOException;

/**
 * @author lijunwei[lijunwei@kingsoft.com]
 * 
 * @date 2014年10月15日 下午5:09:30
 * 
 * @description 
 **/
public class ProcessObjectResponse extends Ks3WebServiceDefaultResponse<ProcessObjectResult> {
	public int[] expectedStatus() {
		return new int[]{200};
	}

	@Override
	public void preHandle() {
		try {
			String jsonText = EntityUtils.toString(super.getHttpResponse().getEntity());
			this.result = ProcessObjectResult.fromJson(jsonText);
		} catch (ParseException | IOException e) {
			throw new Ks3ClientException("failed to deserialize ImgSaveAsResult from json text", e);
		}
	}
}
