
package com.ksyun.ks3.signer.internal;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * A bounded linked hash map that would remove the eldest entry when the map
 * size exceeds a configurable maximum.
 */
final class BoundedLinkedHashMap<K,V> extends LinkedHashMap<K,V> {
    private static final long serialVersionUID = 1L;
    private final int maxSize;
    BoundedLinkedHashMap(int maxSize) {
        this.maxSize = maxSize;
    }

    /**
     * {@inheritDoc}
     * 
     * Returns true if the size of this map exceeds the maximum.
     */
    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return size() > maxSize;
    }

    /**
     * Returns the maximum size of this map beyond which the eldest entry
     * will get removed.
     */
    int getMaxSize() {
        return maxSize;
    }
}