
package com.ksyun.ks3.signer.internal;


import com.ksyun.ks3.annotation.Immutable;

/**
 * Holds the signing key and the number of days since epoch for the date for
 * which the signing key was generated.
 */
@Immutable
public final class SignerKey {

    private final long numberOfDaysSinceEpoch;

    private final byte[] signingKey;

    public SignerKey(long numberOfDaysSinceEpoch, byte[] signingKey) {
        if (numberOfDaysSinceEpoch <= 0L) {
            throw new IllegalArgumentException(
                    "Not able to cache signing key. Signing date to be cached is invalid");
        }
        if (signingKey == null) {
            throw new IllegalArgumentException(
                    "Not able to cache signing key. Signing Key to be cached are null");
        }
        this.numberOfDaysSinceEpoch = numberOfDaysSinceEpoch;
        this.signingKey = signingKey.clone();
    }

    /**
     * Returns the number of days since epoch for the date used for generating
     * signing key.
     */
    public long getNumberOfDaysSinceEpoch() {
        return numberOfDaysSinceEpoch;
    }

    /**
     * Returns a copy of the signing key.
     */
    public byte[] getSigningKey() {
        return signingKey.clone();
    }
}
