/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3;

import com.ksyun.ks3.exception.Ks3ClientException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LengthCheckInputStream
extends FilterInputStream {
    public static final boolean INCLUDE_SKIPPED_BYTES = true;
    public static final boolean EXCLUDE_SKIPPED_BYTES = false;
    private final long expectedLength;
    private final boolean includeSkipped;
    private long dataLength;
    private long marked;

    public LengthCheckInputStream(InputStream in, long expectedLength, boolean includeSkipped) {
        super(in);
        if (expectedLength < 0L) {
            throw new IllegalArgumentException();
        }
        this.expectedLength = expectedLength;
        this.includeSkipped = includeSkipped;
    }

    @Override
    public int read() throws IOException {
        int c = super.read();
        if (c >= 0) {
            ++this.dataLength;
        }
        this.checkLength(c == -1);
        return c;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int readLen = super.read(b, off, len);
        this.dataLength += readLen >= 0 ? (long)readLen : 0L;
        this.checkLength(readLen == -1);
        return readLen;
    }

    @Override
    public void mark(int readlimit) {
        super.mark(readlimit);
        this.marked = this.dataLength;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        if (super.markSupported()) {
            this.dataLength = this.marked;
        }
    }

    private void checkLength(boolean eof) {
        if (eof) {
            if (this.dataLength != this.expectedLength) {
                throw new Ks3ClientException("Data read (" + this.dataLength + ") has a different length than the expected (" + this.expectedLength + ")");
            }
        } else if (this.dataLength > this.expectedLength) {
            throw new Ks3ClientException("More data read (" + this.dataLength + ") than expected (" + this.expectedLength + ")");
        }
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped = super.skip(n);
        if (this.includeSkipped && skipped > 0L) {
            this.dataLength += skipped;
            this.checkLength(false);
        }
        return skipped;
    }
}

