/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.dto;

import com.ksyun.ks3.dto.ObjectTag;
import com.ksyun.ks3.exception.client.ClientIllegalArgumentException;
import com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator;
import com.ksyun.ks3.service.common.StorageClass;
import com.ksyun.ks3.utils.StringUtils;
import java.util.Date;
import java.util.List;

public class BucketLifecycleConfiguration {
    private List<Rule> rules;

    public List<Rule> getRules() {
        return this.rules;
    }

    public void setRules(List<Rule> rules) {
        this.rules = rules;
    }

    public BucketLifecycleConfiguration(List<Rule> rules) {
        this.rules = rules;
    }

    public BucketLifecycleConfiguration() {
    }

    public String toString() {
        return "BucketLifecycleConfiguration(rules=" + this.getRules() + ")";
    }

    public static class AbortMultipartUpload {
        private Integer expirationDays;
        private Date createdBeforeDate;

        public AbortMultipartUpload() {
        }

        public AbortMultipartUpload(int expirationDays) {
            this.expirationDays = expirationDays;
        }

        public AbortMultipartUpload(Date createdBeforeDate) {
            this.createdBeforeDate = createdBeforeDate;
        }

        public Integer getExpirationDays() {
            return this.expirationDays;
        }

        public void setExpirationDays(Integer expirationDays) {
            this.expirationDays = expirationDays;
        }

        public AbortMultipartUpload withExpirationDays(Integer expirationDays) {
            this.setExpirationDays(expirationDays);
            return this;
        }

        public boolean hasExpirationDays() {
            return this.expirationDays != null;
        }

        public Date getCreatedBeforeDate() {
            return this.createdBeforeDate;
        }

        public void setCreatedBeforeDate(Date createdBeforeDate) {
            this.createdBeforeDate = createdBeforeDate;
        }

        public AbortMultipartUpload withCreatedBeforeDate(Date createdBeforeDate) {
            this.setCreatedBeforeDate(createdBeforeDate);
            return this;
        }

        public boolean hasCreatedBeforeDate() {
            return this.createdBeforeDate != null;
        }

        public void validate() throws ClientIllegalArgumentException {
            if (this.expirationDays == null && this.createdBeforeDate == null) {
                throw new ClientIllegalArgumentException("missing expirationDays and createdBeforeDate of abortMultipartUpload");
            }
            if (this.expirationDays != null && this.createdBeforeDate != null) {
                throw new ClientIllegalArgumentException("conflict expirationDays and createdBeforeDate of abortMultipartUpload");
            }
            if (this.expirationDays != null && (this.expirationDays < 1 || this.expirationDays > 10000)) {
                throw ClientIllegalArgumentExceptionGenerator.between("expirationDays", String.valueOf(this.expirationDays), String.valueOf(1), String.valueOf(10000));
            }
        }
    }

    public static class Transition {
        private Integer transDays;
        private Date transDate;
        private String storageClass;

        public Transition() {
        }

        @Deprecated
        public Transition(Integer transDays, StorageClass storageClass) {
            this.transDays = transDays;
            this.storageClass = storageClass.toString();
        }

        @Deprecated
        public Transition(Date transDate, StorageClass storageClass) {
            this.transDate = transDate;
            this.storageClass = storageClass.toString();
        }

        public Transition(Integer transDays, String storageClass) {
            this.transDays = transDays;
            this.storageClass = storageClass;
        }

        public Transition(Date transDate, String storageClass) {
            this.transDate = transDate;
            this.storageClass = storageClass;
        }

        public Integer getTransDays() {
            return this.transDays;
        }

        public void setTransDays(Integer transDays) {
            this.transDays = transDays;
        }

        public Date getTransDate() {
            return this.transDate;
        }

        public void setTransDate(Date transDate) {
            this.transDate = transDate;
        }

        @Deprecated
        public StorageClass getStorageClass() {
            return StorageClass.fromValue(this.storageClass);
        }

        public void setStorageClass(StorageClass storageClass) {
            this.storageClass = storageClass.toString();
        }

        public String getStorageClassName() {
            return this.storageClass;
        }

        public void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        public String toString() {
            return "Transition [transDays=" + this.transDays + ", transDate=" + this.transDate + ", storageClass=" + this.storageClass + "]";
        }

        public void validate() throws ClientIllegalArgumentException {
            if (this.storageClass == null) {
                throw new ClientIllegalArgumentException("missing transition storageClass");
            }
            if (StorageClass.UNKNOWN.toString().equalsIgnoreCase(this.storageClass)) {
                throw new ClientIllegalArgumentException("invalid storage class: " + this.storageClass);
            }
            if (this.transDays == null && this.transDate == null) {
                throw new ClientIllegalArgumentException("missing transition transDate and days");
            }
            if (this.transDays != null && this.transDate != null) {
                throw new ClientIllegalArgumentException("conflict transition transDate and days");
            }
            if (this.transDays != null) {
                if (this.transDays <= 0) {
                    throw new ClientIllegalArgumentException("transDays must be positive");
                }
                if (this.transDays > 10000) {
                    throw new ClientIllegalArgumentException("transDays cannot be greater than 10000");
                }
            }
        }
    }

    public static class Rule {
        private String id;
        private String prefix;
        private Status status;
        private Integer expirationInDays;
        private Date expirationDate;
        private List<Transition> storageTransitions;
        private List<ObjectTag> tagSet;
        private AbortMultipartUpload abortMultipartUpload;

        public List<ObjectTag> getTagSet() {
            return this.tagSet;
        }

        public void setTagSet(List<ObjectTag> tagSet) {
            this.tagSet = tagSet;
        }

        public List<Transition> getStorageTransitions() {
            return this.storageTransitions;
        }

        public void setStorageTransitions(List<Transition> storageTransitions) {
            this.storageTransitions = storageTransitions;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public void setExpirationInDays(Integer expirationInDays) {
            this.expirationInDays = expirationInDays;
        }

        public String getId() {
            return this.id;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public Integer getExpirationInDays() {
            return this.expirationInDays;
        }

        public Status getStatus() {
            return this.status;
        }

        public void setStatus(Status status) {
            this.status = status;
        }

        public void setExpirationDate(Date expirationDate) {
            this.expirationDate = expirationDate;
        }

        public Date getExpirationDate() {
            return this.expirationDate;
        }

        public AbortMultipartUpload getAbortMultipartUpload() {
            return this.abortMultipartUpload;
        }

        public void setAbortMultipartUpload(AbortMultipartUpload abortMultipartUpload) {
            this.abortMultipartUpload = abortMultipartUpload;
        }

        public String toString() {
            return "BucketLifecycleConfiguration.Rule(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", status=" + (Object)((Object)this.getStatus()) + ", expirationInDays=" + this.getExpirationInDays() + ", expirationDate=" + this.getExpirationDate() + ", storageTransitions=" + this.getStorageTransitions() + ", tagSet=" + this.getTagSet() + ", AbortMultipartUpload=" + this.getAbortMultipartUpload() + ")";
        }

        public void validate() throws ClientIllegalArgumentException {
            this.validateRuleId();
            this.validateExpiration();
            this.validateStatus();
            this.validateStorageTransition();
            this.validateAbortMultipartUpload();
        }

        private void validateRuleId() throws ClientIllegalArgumentException {
            if (StringUtils.isBlank(this.id)) {
                throw ClientIllegalArgumentExceptionGenerator.notNull("rule id");
            }
            if (this.id.length() > 255) {
                throw ClientIllegalArgumentExceptionGenerator.between("rule id", this.id, "1", String.valueOf(255));
            }
        }

        private void validateExpiration() throws ClientIllegalArgumentException {
            if (this.expirationInDays != null && this.expirationDate != null) {
                throw new ClientIllegalArgumentException("conflict expirationInDays and expirationDate");
            }
            if (this.expirationInDays != null && (this.expirationInDays < 1 || this.expirationInDays > 10000)) {
                throw ClientIllegalArgumentExceptionGenerator.between("expirationInDays", String.valueOf(this.expirationInDays), String.valueOf(1), String.valueOf(10000));
            }
        }

        private void validateStorageTransition() throws ClientIllegalArgumentException {
            if (this.storageTransitions != null) {
                for (Transition transition : this.storageTransitions) {
                    transition.validate();
                }
            }
        }

        private void validateStatus() throws ClientIllegalArgumentException {
            if (this.status == null) {
                throw ClientIllegalArgumentExceptionGenerator.notNull("status");
            }
        }

        private void validateAbortMultipartUpload() throws ClientIllegalArgumentException {
            if (this.abortMultipartUpload != null) {
                this.abortMultipartUpload.validate();
            }
        }
    }

    public static enum Status {
        ENABLED("Enabled"),
        DISABLED("Disabled");

        private String status;

        private Status(String status) {
            this.status = status;
        }

        public String status2Str() {
            return this.status;
        }

        public static Status str2Status(String statusStr) {
            Status status = null;
            for (Status senum : Status.values()) {
                if (!senum.status.equals(statusStr)) continue;
                status = senum;
                break;
            }
            return status;
        }
    }
}

