/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.ksyun.ks3.dto.CannedAccessControlList;
import com.ksyun.ks3.exception.Ks3ClientException;
import java.io.IOException;
import java.util.List;

public class BucketMirror {
    private static final ObjectMapper OBJ_MAPPER = new ObjectMapper();
    private Version version;
    private boolean useDefaultRobots;
    private AsyncMirrorRule asyncMirrorRule;
    private List<SyncMirrorRule> syncMirrorRules;
    private String createdTime;
    private String lastModifiedTime;

    public BucketMirror() {
    }

    public BucketMirror(Version version, boolean useDefaultRobots, AsyncMirrorRule asyncMirrorRule, List<SyncMirrorRule> syncMirrorRules) {
        this.version = version;
        this.useDefaultRobots = useDefaultRobots;
        this.asyncMirrorRule = asyncMirrorRule;
        this.syncMirrorRules = syncMirrorRules;
    }

    public String toJson() {
        try {
            return OBJ_MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new Ks3ClientException("failed to serialize bucketMirror to json text", e);
        }
    }

    public static BucketMirror fromJson(String jsonText) {
        try {
            return (BucketMirror)OBJ_MAPPER.readValue(jsonText, BucketMirror.class);
        }
        catch (IOException e) {
            throw new Ks3ClientException("failed to deserialize bucketMirror from json text", e);
        }
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public boolean isUseDefaultRobots() {
        return this.useDefaultRobots;
    }

    public void setUseDefaultRobots(boolean useDefaultRobots) {
        this.useDefaultRobots = useDefaultRobots;
    }

    public AsyncMirrorRule getAsyncMirrorRule() {
        return this.asyncMirrorRule;
    }

    public void setAsyncMirrorRule(AsyncMirrorRule asyncMirrorRule) {
        this.asyncMirrorRule = asyncMirrorRule;
    }

    public List<SyncMirrorRule> getSyncMirrorRules() {
        return this.syncMirrorRules;
    }

    public void setSyncMirrorRules(List<SyncMirrorRule> syncMirrorRules) {
        this.syncMirrorRules = syncMirrorRules;
    }

    public String getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(String createdTime) {
        this.createdTime = createdTime;
    }

    public String getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public void setLastModifiedTime(String lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public String toString() {
        return "BucketMirror [asyncMirrorRule=" + this.asyncMirrorRule + ", createdTime=" + this.createdTime + ", lastModifiedTime=" + this.lastModifiedTime + ", syncMirrorRules=" + this.syncMirrorRules + ", useDefaultRobots=" + this.useDefaultRobots + ", version=" + (Object)((Object)this.version) + "]";
    }

    static {
        OBJ_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        OBJ_MAPPER.setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
        OBJ_MAPPER.configure(SerializationFeature.WRITE_ENUMS_USING_TO_STRING, true);
        OBJ_MAPPER.configure(DeserializationFeature.READ_ENUMS_USING_TO_STRING, true);
    }

    public static class Header {
        String key;
        String value;

        public Header() {
        }

        public Header(String key) {
            this.key = key;
        }

        public Header(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String toString() {
            return "Header [key=" + this.key + ", value=" + this.value + "]";
        }
    }

    public static class SavingSetting {
        CannedAccessControlList acl;

        public SavingSetting() {
        }

        public SavingSetting(CannedAccessControlList acl) {
            this.acl = acl;
        }

        public CannedAccessControlList getAcl() {
            return this.acl;
        }

        public void setAcl(CannedAccessControlList acl) {
            this.acl = acl;
        }

        public String toString() {
            return "SavingSetting [acl=" + (Object)((Object)this.acl) + "]";
        }
    }

    public static class HeaderSetting {
        List<Header> setHeaders;
        List<Header> removeHeaders;
        boolean passAll;
        List<Header> passHeaders;

        public HeaderSetting() {
        }

        public HeaderSetting(List<Header> setHeaders, List<Header> removeHeaders, boolean passAll, List<Header> passHeaders) {
            this.setHeaders = setHeaders;
            this.removeHeaders = removeHeaders;
            this.passAll = passAll;
            this.passHeaders = passHeaders;
        }

        public List<Header> getSetHeaders() {
            return this.setHeaders;
        }

        public void setSetHeaders(List<Header> setHeaders) {
            this.setHeaders = setHeaders;
        }

        public List<Header> getRemoveHeaders() {
            return this.removeHeaders;
        }

        public void setRemoveHeaders(List<Header> removeHeaders) {
            this.removeHeaders = removeHeaders;
        }

        public boolean isPassAll() {
            return this.passAll;
        }

        public void setPassAll(boolean passAll) {
            this.passAll = passAll;
        }

        public List<Header> getPassHeaders() {
            return this.passHeaders;
        }

        public void setPassHeaders(List<Header> passHeaders) {
            this.passHeaders = passHeaders;
        }

        public String toString() {
            return "HeaderSetting [passAll=" + this.passAll + ", passHeaders=" + this.passHeaders + ", removeHeaders=" + this.removeHeaders + ", setHeaders=" + this.setHeaders + "]";
        }
    }

    public static class MirrorRequestSetting {
        boolean passQueryString;
        boolean follow3xx;
        HeaderSetting headerSetting;

        public MirrorRequestSetting() {
        }

        public MirrorRequestSetting(boolean passQueryString, boolean follow3xx, HeaderSetting headerSetting) {
            this.passQueryString = passQueryString;
            this.follow3xx = follow3xx;
            this.headerSetting = headerSetting;
        }

        public boolean isPassQueryString() {
            return this.passQueryString;
        }

        public void setPassQueryString(boolean passQueryString) {
            this.passQueryString = passQueryString;
        }

        public boolean isFollow3xx() {
            return this.follow3xx;
        }

        public void setFollow3xx(boolean follow3xx) {
            this.follow3xx = follow3xx;
        }

        public HeaderSetting getHeaderSetting() {
            return this.headerSetting;
        }

        public void setHeaderSetting(HeaderSetting headerSetting) {
            this.headerSetting = headerSetting;
        }

        public String toString() {
            return "MirrorRequestSetting [follow3xx=" + this.follow3xx + ", headerSetting=" + this.headerSetting + ", passQueryString=" + this.passQueryString + "]";
        }
    }

    public static class MatchCondition {
        List<String> httpCodes;
        List<String> keyPrefixes;

        public MatchCondition() {
        }

        public MatchCondition(List<String> httpCodes, List<String> keyPrefixes) {
            this.httpCodes = httpCodes;
            this.keyPrefixes = keyPrefixes;
        }

        public List<String> getHttpCodes() {
            return this.httpCodes;
        }

        public void setHttpCodes(List<String> httpCodes) {
            this.httpCodes = httpCodes;
        }

        public List<String> getKeyPrefixes() {
            return this.keyPrefixes;
        }

        public void setKeyPrefixes(List<String> keyPrefixes) {
            this.keyPrefixes = keyPrefixes;
        }

        public String toString() {
            return "MatchCondition [httpCodes=" + this.httpCodes + ", keyPrefixes=" + this.keyPrefixes + "]";
        }
    }

    public static class SyncMirrorRule {
        MatchCondition matchCondition;
        String mirrorUrl;
        MirrorRequestSetting mirrorRequestSetting;
        SavingSetting savingSetting;

        public SyncMirrorRule() {
        }

        public SyncMirrorRule(MatchCondition matchCondition, String mirrorUrl, MirrorRequestSetting mirrorRequestSetting, SavingSetting savingSetting) {
            this.matchCondition = matchCondition;
            this.mirrorUrl = mirrorUrl;
            this.mirrorRequestSetting = mirrorRequestSetting;
            this.savingSetting = savingSetting;
        }

        public MatchCondition getMatchCondition() {
            return this.matchCondition;
        }

        public void setMatchCondition(MatchCondition matchCondition) {
            this.matchCondition = matchCondition;
        }

        public String getMirrorUrl() {
            return this.mirrorUrl;
        }

        public void setMirrorUrl(String mirrorUrl) {
            this.mirrorUrl = mirrorUrl;
        }

        public MirrorRequestSetting getMirrorRequestSetting() {
            return this.mirrorRequestSetting;
        }

        public void setMirrorRequestSetting(MirrorRequestSetting mirrorRequestSetting) {
            this.mirrorRequestSetting = mirrorRequestSetting;
        }

        public SavingSetting getSavingSetting() {
            return this.savingSetting;
        }

        public void setSavingSetting(SavingSetting savingSetting) {
            this.savingSetting = savingSetting;
        }

        public String toString() {
            return "SyncMirrorRule [matchCondition=" + this.matchCondition + ", mirrorRequestSetting=" + this.mirrorRequestSetting + ", mirrorUrl=" + this.mirrorUrl + ", savingSetting=" + this.savingSetting + "]";
        }
    }

    public static class AsyncMirrorRule {
        List<String> mirrorUrls;
        SavingSetting savingSetting;

        public AsyncMirrorRule() {
        }

        public AsyncMirrorRule(List<String> mirrorUrls, SavingSetting savingSetting) {
            this.mirrorUrls = mirrorUrls;
            this.savingSetting = savingSetting;
        }

        public List<String> getMirrorUrls() {
            return this.mirrorUrls;
        }

        public void setMirrorUrls(List<String> mirrorUrls) {
            this.mirrorUrls = mirrorUrls;
        }

        public SavingSetting getSavingSetting() {
            return this.savingSetting;
        }

        public void setSavingSetting(SavingSetting savingSetting) {
            this.savingSetting = savingSetting;
        }

        public String toString() {
            return "AsyncMirrorRule [mirrorUrls=" + this.mirrorUrls + ", savingSetting=" + this.savingSetting + "]";
        }
    }

    public static enum Version {
        V3;

    }
}

