/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.dto;

import com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator;

public enum Permission {
    FullControl("FULL_CONTROL", "x-kss-grant-full-control"),
    Read("READ", "x-kss-grant-read"),
    Write("WRITE", "x-kss-grant-write");

    private String permissionString;
    private String headerName;

    private Permission(String permissionString, String headerName) {
        this.permissionString = permissionString;
        this.headerName = headerName;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public String toString() {
        return this.permissionString;
    }

    public static Permission load(String value) {
        if (value.equals(FullControl.toString())) {
            return FullControl;
        }
        if (value.equals(Read.toString())) {
            return Read;
        }
        if (value.equals(Write.toString())) {
            return Write;
        }
        throw ClientIllegalArgumentExceptionGenerator.notCorrect("permission", value, "FULL_CONTROL,READ,WRITE");
    }
}

