/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.dto;

import com.ksyun.ks3.utils.Base64;
import com.ksyun.ks3.utils.StringUtils;
import javax.crypto.SecretKey;

public class SSECustomerKey {
    private final String base64EncodedKey;
    private String base64EncodedMd5;
    private String algorithm;

    public SSECustomerKey(String base64EncodedKey) {
        if (base64EncodedKey == null || base64EncodedKey.length() == 0) {
            throw new IllegalArgumentException("Encryption key must be specified");
        }
        this.algorithm = "AES256";
        this.base64EncodedKey = base64EncodedKey;
    }

    public SSECustomerKey(byte[] rawKeyMaterial) {
        if (rawKeyMaterial == null || rawKeyMaterial.length == 0) {
            throw new IllegalArgumentException("Encryption key must be specified");
        }
        this.algorithm = "AES256";
        this.base64EncodedKey = Base64.encodeAsString(rawKeyMaterial);
    }

    public SSECustomerKey(SecretKey key) {
        if (key == null) {
            throw new IllegalArgumentException("Encryption key must be specified");
        }
        this.algorithm = "AES256";
        this.base64EncodedKey = Base64.encodeAsString(key.getEncoded());
    }

    public String getBase64EncodedMd5() {
        return this.base64EncodedMd5;
    }

    public void setBase64EncodedMd5(String base64EncodedMd5) {
        this.base64EncodedMd5 = base64EncodedMd5;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getBase64EncodedKey() {
        return this.base64EncodedKey;
    }

    public String toString() {
        return StringUtils.object2string(this);
    }
}

