/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.exception;

import com.ksyun.ks3.exception.Ks3ClientException;
import com.ksyun.ks3.utils.Jackson;
import com.ksyun.ks3.utils.StringUtils;
import com.ksyun.ks3.utils.XmlReader;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.w3c.dom.Document;

public class Ks3ServiceException
extends Ks3ClientException {
    private static final long serialVersionUID = 5225806336951827450L;
    private static final Log log = LogFactory.getLog(Ks3ServiceException.class);
    private String errorCode;
    private int statusCode;
    private String expectedStatusCode;
    private String errorMessage;
    private String resource;
    private String requestId;
    private static final String DEFAULT_VALUE = "unknown";

    public Ks3ServiceException() {
        super("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ks3ServiceException(HttpRequestBase request, HttpResponse response, String expected) {
        super("");
        this.expectedStatusCode = expected;
        this.statusCode = response.getStatusLine().getStatusCode();
        try {
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                return;
            }
            InputStream in = entity.getContent();
            String xml = StringUtils.inputStream2String(in);
            if (xml.startsWith("<?xml") || xml.startsWith("<!")) {
                log.debug((Object)xml);
                Document document = new XmlReader(xml).getDocument();
                this.errorMessage = this.getByTagName(document, "Message");
                this.errorCode = this.getByTagName(document, "Code");
                this.resource = this.getByTagName(document, "Resource");
                this.requestId = this.getByTagName(document, "RequestId");
                String condition = this.getByTagName(document, "Condition", "");
                if (!StringUtils.isBlank(condition)) {
                    this.errorMessage = this.errorMessage + " Condition: " + condition;
                }
            } else {
                Map map = Jackson.fromJsonString(xml, Map.class);
                this.errorCode = map.containsKey("errorCode") ? String.valueOf(map.get("errorCode")) + "" : "400";
                this.errorMessage = map.containsKey("tipInfo") ? (String)map.get("tipInfo") : "Bad Request";
            }
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
        finally {
            if (request != null) {
                request.abort();
            }
            try {
                HttpEntity entity = response.getEntity();
                if (entity != null && entity.getContent() != null) {
                    entity.getContent().close();
                }
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
        }
    }

    private String getByTagName(Document document, String tagName) {
        return this.getByTagName(document, tagName, DEFAULT_VALUE);
    }

    private String getByTagName(Document document, String tagName, String defaultValue) {
        try {
            return document.getElementsByTagName(tagName).item(0).getTextContent();
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public Ks3ServiceException(HttpResponse response, String expected) {
        this(null, response, expected);
    }

    @Override
    public String toString() {
        return this.getClass().getName() + ": " + this.getMessage();
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    @Deprecated
    public int getStatueCode() {
        return this.getStatusCode();
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getResource() {
        return this.resource;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    @Deprecated
    public String getExpectedStatueCode() {
        return this.getExpectedStatusCode();
    }

    @Deprecated
    public void setExpectedStatueCode(String expectedStatusCode) {
        this.setExpectedStatusCode(expectedStatusCode);
    }

    public String getExpectedStatusCode() {
        return this.expectedStatusCode;
    }

    public void setExpectedStatusCode(String expectedStatusCode) {
        this.expectedStatusCode = expectedStatusCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    @Deprecated
    public void setStatueCode(int statusCode) {
        this.setStatusCode(statusCode);
    }

    public void setErrorMessage(String message) {
        this.errorMessage = message;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public <X extends Ks3ServiceException> RuntimeException convert(String reqid) {
        String error;
        if (!StringUtils.isBlank(reqid)) {
            this.setRequestId(reqid);
        }
        if (StringUtils.isBlank(this.getErrorCode()) || "unknow".equals(this.getErrorCode()) || DEFAULT_VALUE.equalsIgnoreCase(this.getErrorCode())) {
            if (this.statusCode == 400) {
                this.setErrorCode("InvalidArgument");
            } else if (this.statusCode == 403) {
                this.setErrorCode("AccessDenied");
            } else if (this.statusCode == 404) {
                this.setErrorCode("NotFound");
            } else if (this.statusCode == 405) {
                this.setErrorCode("MethodNotAllowed");
            }
        }
        if (!StringUtils.isBlank(error = this.getErrorCode())) {
            error = error.substring(0, 1).toUpperCase() + error.substring(1);
        }
        String classString = "com.ksyun.ks3.exception.serviceside." + error + "Exception";
        try {
            Ks3ServiceException e = (Ks3ServiceException)Class.forName(classString).newInstance();
            e.setErrorMessage(this.getErrorMessage());
            e.setErrorCode(this.getErrorCode());
            e.setExpectedStatusCode(this.getExpectedStatusCode());
            e.setRequestId(this.getRequestId());
            e.setResource(this.getResource());
            e.setStatusCode(this.getStatusCode());
            e.setStackTrace(this.getStackTrace());
            return e;
        }
        catch (Throwable e) {
            return this;
        }
    }

    @Override
    public String getMessage() {
        return "[RequestId:" + this.requestId + ", Resource:" + this.resource + ", Status code:" + this.statusCode + ", Expected status code:" + this.expectedStatusCode + ", Error code:" + this.errorCode + ", Error message:" + this.errorMessage + "]";
    }
}

