/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.http;

import com.ksyun.ks3.exception.Ks3ClientException;
import com.ksyun.ks3.http.HttpClientConfig;
import com.ksyun.ks3.http.internal.Ks3DnsResolver;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.ChallengeState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;

public class HttpClientFactory {
    private final Log log = LogFactory.getLog(this.getClass());

    public CloseableHttpClient createHttpClient(HttpClientConfig config) {
        SocketConfig soConfig = SocketConfig.custom().setTcpNoDelay(true).build();
        int socketSendBufferSizeHint = config.getSocketSendBufferSizeHint();
        int socketReceiveBufferSizeHint = config.getSocketReceiveBufferSizeHint();
        int buffersize = 0;
        if (socketSendBufferSizeHint > 0 || socketReceiveBufferSizeHint > 0) {
            buffersize = Math.max(socketSendBufferSizeHint, socketReceiveBufferSizeHint);
        }
        ConnectionConfig coConfig = ConnectionConfig.custom().setBufferSize(buffersize).build();
        RequestConfig reConfig = null;
        RequestConfig.Builder builder = RequestConfig.custom().setConnectTimeout(config.getConnectionTimeOut()).setSocketTimeout(config.getSocketTimeOut()).setStaleConnectionCheckEnabled(true);
        try {
            if (RequestConfig.class.getDeclaredField("normalizeUri") != null) {
                Method me = RequestConfig.Builder.class.getDeclaredMethod("setNormalizeUri", Boolean.TYPE);
                me.invoke((Object)builder, false);
            }
        }
        catch (Exception me) {
            // empty catch block
        }
        reConfig = builder.build();
        PlainConnectionSocketFactory sf = PlainConnectionSocketFactory.getSocketFactory();
        SSLConnectionSocketFactory sslsf = null;
        try {
            SSLContext sslContext = SSLContexts.custom().build();
            String version0 = System.getProperty("java.specification.version");
            float version = 0.0f;
            try {
                version = Float.valueOf(version0).floatValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (version >= 1.7f) {
                this.log.debug((Object)("java version " + version + ", use STRICT_HOSTNAME_VERIFIER"));
                sslsf = new SSLConnectionSocketFactory(sslContext, SSLConnectionSocketFactory.STRICT_HOSTNAME_VERIFIER);
            } else {
                this.log.debug((Object)("java version " + version + ", use BROWSER_COMPATIBLE_HOSTNAME_VERIFIER"));
                sslsf = new SSLConnectionSocketFactory(sslContext, SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
            }
        }
        catch (Exception e) {
            throw new Ks3ClientException("Unable to access default SSL context", e);
        }
        Registry r = RegistryBuilder.create().register("http", (Object)sf).register("https", (Object)sslsf).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(r, null, null, (DnsResolver)Ks3DnsResolver.INSTANCE, (long)config.getConnectionTTL(), TimeUnit.MILLISECONDS);
        connectionManager.setMaxTotal(config.getMaxConnections());
        connectionManager.setDefaultMaxPerRoute(connectionManager.getMaxTotal());
        connectionManager.setDefaultConnectionConfig(coConfig);
        connectionManager.setDefaultSocketConfig(soConfig);
        String proxyHost = config.getProxyHost();
        int proxyPort = config.getProxyPort();
        CloseableHttpClient httpClient = null;
        if (proxyHost != null && proxyPort > 0) {
            HttpHost proxyHttpHost = new HttpHost(proxyHost, proxyPort);
            String proxyUsername = config.getProxyUserName();
            String proxyPassword = config.getProxyPassWord();
            String proxyDomain = config.getProxyDomain();
            String proxyWorkstation = config.getProxyWorkStation();
            BasicCredentialsProvider creprovide = null;
            if (proxyUsername != null && proxyPassword != null) {
                creprovide = new BasicCredentialsProvider();
                creprovide.setCredentials(new AuthScope(proxyHost, proxyPort), (Credentials)new NTCredentials(proxyUsername, proxyPassword, proxyWorkstation, proxyDomain));
            }
            PreemptiveProxyAuth interceptor = null;
            if (config.isPreemptiveBasicProxyAuth()) {
                interceptor = new PreemptiveProxyAuth(proxyHttpHost);
            }
            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxyHttpHost);
            httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setRedirectStrategy((RedirectStrategy)new NeverFollowRedirectStrategy()).setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(config.getMaxRetry(), false)).setUserAgent(config.getUserAgent()).setDefaultRequestConfig(reConfig).setRoutePlanner((HttpRoutePlanner)routePlanner).setDefaultCredentialsProvider((CredentialsProvider)creprovide).addInterceptorFirst((HttpRequestInterceptor)interceptor).build();
        } else {
            httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setRedirectStrategy((RedirectStrategy)new NeverFollowRedirectStrategy()).setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(config.getMaxRetry(), false)).setUserAgent(config.getUserAgent()).setDefaultRequestConfig(reConfig).build();
        }
        return httpClient;
    }

    private static class PreemptiveProxyAuth
    implements HttpRequestInterceptor {
        private final HttpHost proxyHost;

        public PreemptiveProxyAuth(HttpHost proxyHost) {
            this.proxyHost = proxyHost;
        }

        public void process(HttpRequest request, HttpContext context) {
            BasicScheme basicScheme = new BasicScheme(ChallengeState.PROXY);
            if (context.getAttribute("http.auth.auth-cache") == null) {
                BasicAuthCache authCache = new BasicAuthCache();
                authCache.put(this.proxyHost, (AuthScheme)basicScheme);
                context.setAttribute("http.auth.auth-cache", (Object)authCache);
            } else {
                AuthCache authCache = (AuthCache)context.getAttribute("http.auth.auth-cache");
                authCache.put(this.proxyHost, (AuthScheme)basicScheme);
            }
        }
    }

    private static final class NeverFollowRedirectStrategy
    extends DefaultRedirectStrategy {
        private NeverFollowRedirectStrategy() {
        }

        public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
            return false;
        }

        public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
            return null;
        }
    }
}

