/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.common;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public enum BucketType {
    EXTREME_PL1("EXTREME_PL1"),
    EXTREME_PL2("EXTREME_PL2"),
    EXTREME_PL3("EXTREME_PL3"),
    Normal("NORMAL"),
    IA("IA"),
    Archive("ARCHIVE"),
    UNKNOWN("UNKNOWN");

    private static final Log log;
    private final String typeId;

    public static BucketType fromValue(String typeString) throws IllegalArgumentException {
        for (BucketType type : BucketType.values()) {
            if (!type.toString().equals(typeString)) continue;
            return type;
        }
        log.warn((Object)("unknown bucket type: " + typeString + ", use " + (Object)((Object)UNKNOWN) + " instead"));
        return UNKNOWN;
    }

    private BucketType(String id) {
        this.typeId = id;
    }

    public String toString() {
        return this.typeId;
    }

    static {
        log = LogFactory.getLog(BucketType.class);
    }
}

