/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.common;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public enum StorageClass {
    EXTREME_PL1("EXTREME_PL1"),
    EXTREME_PL2("EXTREME_PL2"),
    EXTREME_PL3("EXTREME_PL3"),
    Standard("STANDARD"),
    StandardInfrequentAccess("STANDARD_IA"),
    Archive("ARCHIVE"),
    UNKNOWN("UNKNOWN");

    private static final Log log;
    private final String storageClassId;

    public static StorageClass fromValue(String s3StorageClassString) throws IllegalArgumentException {
        for (StorageClass storageClass : StorageClass.values()) {
            if (!storageClass.toString().equals(s3StorageClassString)) continue;
            return storageClass;
        }
        log.warn((Object)("unknown storage class: " + s3StorageClassString + ", use " + (Object)((Object)UNKNOWN) + " instead"));
        return UNKNOWN;
    }

    private StorageClass(String id) {
        this.storageClassId = id;
    }

    public String toString() {
        return this.storageClassId;
    }

    static {
        log = LogFactory.getLog(StorageClass.class);
    }
}

