/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.encryption.internal;

import com.ksyun.ks3.service.encryption.internal.JceEncryptionConstants;
import java.io.IOException;
import java.io.InputStream;

public class AdjustedRangeInputStream
extends InputStream {
    private InputStream decryptedContents;
    private long virtualAvailable;
    private boolean closed;

    public AdjustedRangeInputStream(InputStream objectContents, long rangeBeginning, long rangeEnd) throws IOException {
        this.decryptedContents = objectContents;
        this.closed = false;
        this.initializeForRead(rangeBeginning, rangeEnd);
    }

    private void initializeForRead(long rangeBeginning, long rangeEnd) throws IOException {
        int numBytesToSkip;
        if (rangeBeginning < (long)JceEncryptionConstants.SYMMETRIC_CIPHER_BLOCK_SIZE) {
            numBytesToSkip = (int)rangeBeginning;
        } else {
            int offsetIntoBlock = (int)(rangeBeginning % (long)JceEncryptionConstants.SYMMETRIC_CIPHER_BLOCK_SIZE);
            numBytesToSkip = JceEncryptionConstants.SYMMETRIC_CIPHER_BLOCK_SIZE + offsetIntoBlock;
        }
        if (numBytesToSkip != 0) {
            while (numBytesToSkip > 0) {
                this.decryptedContents.read();
                --numBytesToSkip;
            }
        }
        this.virtualAvailable = rangeEnd - rangeBeginning + 1L;
    }

    @Override
    public int read() throws IOException {
        int result = 0;
        result = this.virtualAvailable <= 0L ? -1 : this.decryptedContents.read();
        if (result != -1) {
            --this.virtualAvailable;
        } else {
            this.close();
            this.virtualAvailable = 0L;
        }
        return result;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int numBytesRead;
        if (this.virtualAvailable <= 0L) {
            numBytesRead = -1;
        } else {
            if ((long)length > this.virtualAvailable) {
                length = this.virtualAvailable < Integer.MAX_VALUE ? (int)this.virtualAvailable : Integer.MAX_VALUE;
            }
            numBytesRead = this.decryptedContents.read(buffer, offset, length);
        }
        if (numBytesRead != -1) {
            this.virtualAvailable -= (long)numBytesRead;
        } else {
            this.close();
            this.virtualAvailable = 0L;
        }
        return numBytesRead;
    }

    @Override
    public int available() throws IOException {
        int available = this.decryptedContents.available();
        if ((long)available < this.virtualAvailable) {
            return available;
        }
        return (int)this.virtualAvailable;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.decryptedContents.close();
        }
    }

    protected InputStream getWrappedInputStream() {
        return this.decryptedContents;
    }
}

