/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.encryption.internal;

import com.ksyun.ks3.AutoAbortInputStream;
import com.ksyun.ks3.InputSubStream;
import com.ksyun.ks3.RepeatableFileInputStream;
import com.ksyun.ks3.config.Constants;
import com.ksyun.ks3.dto.CompleteMultipartUploadResult;
import com.ksyun.ks3.dto.CopyResult;
import com.ksyun.ks3.dto.GetObjectResult;
import com.ksyun.ks3.dto.InitiateMultipartUploadResult;
import com.ksyun.ks3.dto.Ks3Object;
import com.ksyun.ks3.dto.ObjectMetadata;
import com.ksyun.ks3.dto.PartETag;
import com.ksyun.ks3.dto.PutObjectResult;
import com.ksyun.ks3.exception.Ks3ClientException;
import com.ksyun.ks3.exception.Ks3ServiceException;
import com.ksyun.ks3.service.encryption.S3Direct;
import com.ksyun.ks3.service.encryption.internal.AdjustedRangeInputStream;
import com.ksyun.ks3.service.encryption.internal.CipherLite;
import com.ksyun.ks3.service.encryption.internal.CipherLiteInputStream;
import com.ksyun.ks3.service.encryption.internal.ContentCryptoMaterial;
import com.ksyun.ks3.service.encryption.internal.ContentCryptoScheme;
import com.ksyun.ks3.service.encryption.internal.CryptoRuntime;
import com.ksyun.ks3.service.encryption.internal.EncryptionUtils;
import com.ksyun.ks3.service.encryption.internal.MultipartUploadCryptoContext;
import com.ksyun.ks3.service.encryption.internal.S3CryptoModuleBase;
import com.ksyun.ks3.service.encryption.internal.S3CryptoScheme;
import com.ksyun.ks3.service.encryption.internal.S3ObjectWrapper;
import com.ksyun.ks3.service.encryption.model.CryptoConfiguration;
import com.ksyun.ks3.service.encryption.model.CryptoStorageMode;
import com.ksyun.ks3.service.encryption.model.EncryptionMaterialsProvider;
import com.ksyun.ks3.service.request.CompleteMultipartUploadRequest;
import com.ksyun.ks3.service.request.CopyPartRequest;
import com.ksyun.ks3.service.request.GetObjectRequest;
import com.ksyun.ks3.service.request.InitiateMultipartUploadRequest;
import com.ksyun.ks3.service.request.PutObjectRequest;
import com.ksyun.ks3.service.request.UploadPartRequest;
import com.ksyun.ks3.utils.Jackson;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;

class S3CryptoModuleAE
extends S3CryptoModuleBase<MultipartUploadCryptoContext> {
    private static final boolean IS_MULTI_PART = true;

    S3CryptoModuleAE(S3Direct s3, EncryptionMaterialsProvider encryptionMaterialsProvider, CryptoConfiguration cryptoConfig) {
        super(s3, encryptionMaterialsProvider, cryptoConfig, new S3CryptoScheme(ContentCryptoScheme.AES_GCM));
    }

    protected boolean isStrict() {
        return false;
    }

    protected void securityCheck(ContentCryptoMaterial cekMaterial, S3ObjectWrapper retrieved) {
    }

    @Override
    public PutObjectResult putObjectSecurely(PutObjectRequest putObjectRequest) throws Ks3ClientException, Ks3ServiceException {
        this.appendUserAgent(putObjectRequest, Constants.KS3_ENCRYPTION_CLIENT_USER_AGENT);
        if (this.cryptoConfig.getStorageMode() == CryptoStorageMode.InstructionFile) {
            return this.putObjectUsingInstructionFile(putObjectRequest);
        }
        return this.putObjectUsingMetadata(putObjectRequest);
    }

    private PutObjectResult putObjectUsingMetadata(PutObjectRequest req) throws Ks3ClientException, Ks3ServiceException {
        ContentCryptoMaterial cekMaterial = this.createContentCryptoMaterial(req);
        PutObjectRequest wrappedReq = this.wrapWithCipher(req, cekMaterial);
        req.setObjectMeta(this.updateMetadataWithContentCryptoMaterial(req.getObjectMeta(), req.getFile(), cekMaterial));
        return this.s3.putObject(wrappedReq);
    }

    @Override
    public GetObjectResult getObjectSecurely(GetObjectRequest req) throws Ks3ClientException, Ks3ServiceException {
        this.appendUserAgent(req, Constants.KS3_ENCRYPTION_CLIENT_USER_AGENT);
        long[] desiredRange = req.getRange();
        if (this.isStrict() && desiredRange != null) {
            throw new SecurityException("Range get is not allowed in strict crypto mode");
        }
        long[] adjustedCryptoRange = EncryptionUtils.getAdjustedCryptoRange(desiredRange);
        if (adjustedCryptoRange != null) {
            req.setRange(adjustedCryptoRange[0], adjustedCryptoRange[1]);
        }
        GetObjectResult retrievedRet = this.s3.getObject(req);
        Ks3Object retrieved = null;
        if (!retrievedRet.hasContent()) {
            return retrievedRet;
        }
        retrieved = retrievedRet.getObject();
        if (retrieved == null) {
            return null;
        }
        try {
            Ks3Object oj = this.decipher(req, desiredRange, adjustedCryptoRange, retrieved);
            GetObjectResult result = new GetObjectResult();
            result.setObject(oj);
            return result;
        }
        catch (RuntimeException rc) {
            this.closeStream(retrieved.getObjectContent());
            throw rc;
        }
        catch (Error error) {
            this.closeStream(retrieved.getObjectContent());
            throw error;
        }
    }

    private void closeStream(InputStream stream) {
        try {
            stream.close();
        }
        catch (Exception e) {
            this.log.debug((Object)"Safely ignoring", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Ks3Object decipher(GetObjectRequest req, long[] desiredRange, long[] cryptoRange, Ks3Object retrieved) {
        S3ObjectWrapper wrapped = new S3ObjectWrapper(retrieved);
        if (wrapped.hasEncryptionInfo()) {
            return this.decipherWithMetadata(desiredRange, cryptoRange, wrapped);
        }
        S3ObjectWrapper instructionFile = this.fetchInstructionFile(req);
        if (instructionFile != null) {
            try {
                if (instructionFile.isInstructionFile()) {
                    Ks3Object ks3Object = this.decipherWithInstructionFile(desiredRange, cryptoRange, wrapped, instructionFile);
                    return ks3Object;
                }
            }
            finally {
                try {
                    instructionFile.getObjectContent().close();
                }
                catch (Exception exception) {}
            }
        }
        if (this.isStrict()) {
            try {
                wrapped.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new SecurityException("S3 object with bucket name: " + retrieved.getBucketName() + ", key: " + retrieved.getKey() + " is not encrypted");
        }
        this.log.warn((Object)String.format("Unable to detect encryption information for object '%s' in bucket '%s'. Returning object without decryption.", retrieved.getKey(), retrieved.getBucketName()));
        S3ObjectWrapper adjusted = this.adjustToDesiredRange(wrapped, desiredRange, null);
        return adjusted.getS3Object();
    }

    private Ks3Object decipherWithInstructionFile(long[] desiredRange, long[] cryptoRange, S3ObjectWrapper retrieved, S3ObjectWrapper instructionFile) {
        String json = instructionFile.toJsonString();
        Map<String, String> instruction = Collections.unmodifiableMap(Jackson.fromJsonString(json, Map.class));
        ContentCryptoMaterial cekMaterial = ContentCryptoMaterial.fromInstructionFile(instruction, this.kekMaterialsProvider, this.cryptoConfig.getCryptoProvider(), cryptoRange);
        this.securityCheck(cekMaterial, retrieved);
        S3ObjectWrapper decrypted = this.decrypt(retrieved, cekMaterial, cryptoRange);
        S3ObjectWrapper adjusted = this.adjustToDesiredRange(decrypted, desiredRange, instruction);
        return adjusted.getS3Object();
    }

    private Ks3Object decipherWithMetadata(long[] desiredRange, long[] cryptoRange, S3ObjectWrapper retrieved) {
        ContentCryptoMaterial cekMaterial = ContentCryptoMaterial.fromObjectMetadata(retrieved.getObjectMetadata(), this.kekMaterialsProvider, this.cryptoConfig.getCryptoProvider(), cryptoRange);
        this.securityCheck(cekMaterial, retrieved);
        S3ObjectWrapper decrypted = this.decrypt(retrieved, cekMaterial, cryptoRange);
        S3ObjectWrapper adjusted = this.adjustToDesiredRange(decrypted, desiredRange, null);
        return adjusted.getS3Object();
    }

    protected final S3ObjectWrapper adjustToDesiredRange(S3ObjectWrapper s3object, long[] range, Map<String, String> instruction) {
        if (range == null) {
            return s3object;
        }
        ContentCryptoScheme encryptionScheme = s3object.encryptionSchemeOf(instruction);
        long instanceLen = s3object.getObjectMetadata().getInstanceLength();
        long maxOffset = instanceLen - (long)(encryptionScheme.getTagLengthInBits() / 8) - 1L;
        if (range[1] > maxOffset) {
            range[1] = maxOffset;
            if (range[0] > range[1]) {
                try {
                    s3object.getObjectContent().close();
                }
                catch (IOException ignore) {
                    this.log.trace((Object)"", (Throwable)ignore);
                }
                s3object.setObjectContent(new ByteArrayInputStream(new byte[0]));
                return s3object;
            }
        }
        if (range[0] > range[1]) {
            return s3object;
        }
        try {
            AutoAbortInputStream objectContent = s3object.getObjectContent();
            AdjustedRangeInputStream adjustedRangeContents = new AdjustedRangeInputStream(objectContent, range[0], range[1]);
            s3object.setObjectContent(new AutoAbortInputStream(adjustedRangeContents, objectContent.getRequest()));
            return s3object;
        }
        catch (IOException e) {
            throw new Ks3ClientException("Error adjusting output to desired byte range: " + e.getMessage());
        }
    }

    @Override
    public ObjectMetadata getObjectSecurely(GetObjectRequest getObjectRequest, File destinationFile) throws Ks3ClientException, Ks3ServiceException {
        this.assertParameterNotNull(destinationFile, "The destination file parameter must be specified when downloading an object directly to a file");
        GetObjectResult s3ObjectResult = this.getObjectSecurely(getObjectRequest);
        if (!s3ObjectResult.hasContent()) {
            return s3ObjectResult.getObject().getObjectMetadata();
        }
        OutputStream outputStream = null;
        try {
            int bytesRead;
            outputStream = new BufferedOutputStream(new FileOutputStream(destinationFile));
            byte[] buffer = new byte[10240];
            while ((bytesRead = s3ObjectResult.getObject().getObjectContent().read(buffer)) > -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw new Ks3ClientException("Unable to store object contents to disk: " + e.getMessage(), e);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Exception e) {
                this.log.debug((Object)e.getMessage());
            }
            try {
                s3ObjectResult.getObject().getObjectContent().close();
            }
            catch (Exception e) {
                this.log.debug((Object)e.getMessage());
            }
        }
        return s3ObjectResult.getObject().getObjectMetadata();
    }

    @Override
    public CompleteMultipartUploadResult completeMultipartUploadSecurely(CompleteMultipartUploadRequest req) throws Ks3ClientException, Ks3ServiceException {
        this.appendUserAgent(req, Constants.KS3_ENCRYPTION_CLIENT_USER_AGENT);
        String uploadId = req.getUploadId();
        MultipartUploadCryptoContext uploadContext = (MultipartUploadCryptoContext)this.multipartUploadContexts.get(uploadId);
        if (!uploadContext.hasFinalPartBeenSeen()) {
            throw new Ks3ClientException("Unable to complete an encrypted multipart upload without being told which part was the last.  Without knowing which part was the last, the encrypted data in KS3 is incomplete and corrupt.");
        }
        CompleteMultipartUploadResult result = this.s3.completeMultipartUpload(req);
        if (this.cryptoConfig.getStorageMode() == CryptoStorageMode.InstructionFile) {
            this.s3.putObject(this.createInstructionPutRequest(uploadContext.getBucketName(), uploadContext.getKey(), uploadContext.getContentCryptoMaterial()));
        }
        this.multipartUploadContexts.remove(uploadId);
        return result;
    }

    @Override
    public InitiateMultipartUploadResult initiateMultipartUploadSecurely(InitiateMultipartUploadRequest req) throws Ks3ClientException, Ks3ServiceException {
        this.appendUserAgent(req, Constants.KS3_ENCRYPTION_CLIENT_USER_AGENT);
        ContentCryptoMaterial cekMaterial = this.createContentCryptoMaterial(req);
        if (this.cryptoConfig.getStorageMode() == CryptoStorageMode.ObjectMetadata) {
            ObjectMetadata metadata = req.getObjectMeta();
            if (metadata == null) {
                metadata = new ObjectMetadata();
            }
            req.setObjectMeta(this.updateMetadataWithContentCryptoMaterial(metadata, null, cekMaterial));
        }
        InitiateMultipartUploadResult result = this.s3.initiateMultipartUpload(req);
        MultipartUploadCryptoContext uploadContext = new MultipartUploadCryptoContext(req.getBucket(), req.getKey(), cekMaterial);
        this.multipartUploadContexts.put(result.getUploadId(), uploadContext);
        return result;
    }

    @Override
    public PartETag uploadPartSecurely(UploadPartRequest req) throws Ks3ClientException, Ks3ServiceException {
        boolean partSizeMultipleOfCipherBlockSize;
        this.appendUserAgent(req, Constants.KS3_ENCRYPTION_CLIENT_USER_AGENT);
        int blockSize = this.contentCryptoScheme.getBlockSizeInBytes();
        boolean isLastPart = req.isLastPart();
        String uploadId = req.getUploadId();
        long partSize = req.getInstancePartSize();
        boolean bl = partSizeMultipleOfCipherBlockSize = 0L == partSize % (long)blockSize;
        if (!isLastPart && !partSizeMultipleOfCipherBlockSize) {
            throw new Ks3ClientException("Invalid part size: part sizes for encrypted multipart uploads must be multiples of the cipher block size (" + blockSize + ") with the exception of the last part.");
        }
        MultipartUploadCryptoContext uploadContext = (MultipartUploadCryptoContext)this.multipartUploadContexts.get(uploadId);
        if (uploadContext == null) {
            throw new Ks3ClientException("No client-side information available on upload ID " + uploadId);
        }
        CipherLite cipherLite = uploadContext.getCipherLite();
        req.setInputStream(this.newMultipartS3CipherInputStream(req, cipherLite));
        req.setFile(null);
        req.setFileoffset(0L);
        if (req.isLastPart()) {
            req.setPartSize(partSize + (long)(this.contentCryptoScheme.getTagLengthInBits() / 8));
            if (uploadContext.hasFinalPartBeenSeen()) {
                throw new Ks3ClientException("This part was specified as the last part in a multipart upload, but a previous part was already marked as the last part.  Only the last part of the upload should be marked as the last part.");
            }
            uploadContext.setHasFinalPartBeenSeen(true);
        }
        PartETag result = this.s3.uploadPart(req);
        return result;
    }

    protected final CipherLiteInputStream newMultipartS3CipherInputStream(UploadPartRequest req, CipherLite cipherLite) {
        try {
            InputStream is = req.getInputStream();
            if (req.getFile() != null) {
                is = new InputSubStream(new RepeatableFileInputStream(req.getFile()), req.getFileoffset(), req.getInstancePartSize(), req.isLastPart());
            }
            return new CipherLiteInputStream(is, cipherLite, 2048, true);
        }
        catch (Exception e) {
            throw new Ks3ClientException("Unable to create cipher input stream: " + e.getMessage(), e);
        }
    }

    @Override
    public CopyResult copyPartSecurely(CopyPartRequest copyPartRequest) {
        String uploadId = copyPartRequest.getUploadId();
        MultipartUploadCryptoContext uploadContext = (MultipartUploadCryptoContext)this.multipartUploadContexts.get(uploadId);
        if (!uploadContext.hasFinalPartBeenSeen()) {
            uploadContext.setHasFinalPartBeenSeen(true);
        }
        return this.s3.copyPart(copyPartRequest);
    }

    private PutObjectResult putObjectUsingInstructionFile(PutObjectRequest putObjectRequest) throws Ks3ClientException, Ks3ServiceException {
        ContentCryptoMaterial cekMaterial = this.createContentCryptoMaterial(putObjectRequest);
        PutObjectRequest req = this.wrapWithCipher(putObjectRequest, cekMaterial);
        PutObjectResult result = this.s3.putObject(req);
        this.s3.putObject(this.upateInstructionPutRequest(putObjectRequest, cekMaterial));
        return result;
    }

    private S3ObjectWrapper decrypt(S3ObjectWrapper wrapper, ContentCryptoMaterial cekMaterial, long[] range) {
        AutoAbortInputStream objectContent = wrapper.getObjectContent();
        wrapper.setObjectContent(new AutoAbortInputStream(new CipherLiteInputStream(objectContent, cekMaterial.getCipherLite(), 2048), objectContent.getRequest()));
        return wrapper;
    }

    private S3ObjectWrapper fetchInstructionFile(GetObjectRequest getObjectRequest) {
        try {
            Ks3Object o = this.s3.getObject(EncryptionUtils.createInstructionGetRequest(getObjectRequest)).getObject();
            return o == null ? null : new S3ObjectWrapper(o);
        }
        catch (Ks3ServiceException e) {
            this.log.debug((Object)("Unable to retrieve instruction file : " + e.getMessage()));
            return null;
        }
    }

    private void assertParameterNotNull(Object parameterValue, String errorMessage) {
        if (parameterValue == null) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    @Override
    protected final long ciphertextLength(long originalContentLength) {
        return originalContentLength + (long)(this.contentCryptoScheme.getTagLengthInBits() / 8);
    }

    static {
        CryptoRuntime.enableBouncyCastle();
    }
}

