/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.request;

import com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator;
import com.ksyun.ks3.http.HttpHeaders;
import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.service.request.Ks3WebServiceRequest;
import com.ksyun.ks3.utils.StringUtils;

public class ClearObjectRequest
extends Ks3WebServiceRequest {
    private String bucketName;
    private String objectKey;
    private String retentionId;

    public ClearObjectRequest() {
    }

    public ClearObjectRequest(String bucketName, String objectKey, String retentionId) {
        this.bucketName = bucketName;
        this.objectKey = objectKey;
        this.retentionId = retentionId;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public ClearObjectRequest withBucketName(String bucketName) {
        this.setBucketName(bucketName);
        return this;
    }

    public String getObjectKey() {
        return this.objectKey;
    }

    public void setObjectKey(String objectKey) {
        this.objectKey = objectKey;
    }

    public ClearObjectRequest withObjectKey(String objectKey) {
        this.setObjectKey(objectKey);
        return this;
    }

    public String getRetentionId() {
        return this.retentionId;
    }

    public void setRetentionId(String retentionId) {
        this.retentionId = retentionId;
    }

    public ClearObjectRequest withRetentionId(String retentionId) {
        this.retentionId = retentionId;
        return this;
    }

    @Override
    public void buildRequest(Request request) {
        request.setMethod(HttpMethod.DELETE);
        request.setBucket(this.bucketName);
        request.setKey(this.objectKey);
        request.addQueryParam("clear", "");
        request.addHeader(HttpHeaders.RetentionId, this.retentionId);
    }

    @Override
    public void validateParams() {
        if (StringUtils.isBlank(this.bucketName)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("bucketName");
        }
        if (StringUtils.isBlank(this.objectKey)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("objectKey");
        }
        if (StringUtils.isBlank(this.retentionId)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("retentionId");
        }
    }
}

