/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.request;

import com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator;
import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.service.request.Ks3WebServiceRequest;
import com.ksyun.ks3.utils.StringUtils;

public class DeleteObjectTaggingRequest
extends Ks3WebServiceRequest {
    private String bucketName;
    private String objectName;

    public DeleteObjectTaggingRequest(String bucketName, String objectName) {
        this.bucketName = bucketName;
        this.objectName = objectName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    @Override
    public void buildRequest(Request request) {
        request.setMethod(HttpMethod.DELETE);
        request.setBucket(this.bucketName);
        request.setKey(this.objectName);
        request.addQueryParam("tagging", "");
    }

    @Override
    public void validateParams() {
        if (StringUtils.isBlank(this.bucketName)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("bucketName");
        }
        if (StringUtils.isBlank(this.objectName)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("objectName");
        }
    }
}

