/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.request;

import com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator;
import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.service.request.Ks3WebServiceRequest;
import com.ksyun.ks3.utils.StringUtils;

public class GetObjectACLRequest
extends Ks3WebServiceRequest {
    private String bucket;
    private String key;

    @Override
    public void validateParams() throws IllegalArgumentException {
        if (StringUtils.isBlank(this.bucket)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("bucketname");
        }
    }

    public GetObjectACLRequest(String bucketName, String objectName) {
        this.bucket = bucketName;
        this.key = objectName;
    }

    @Override
    public void buildRequest(Request request) {
        request.setMethod(HttpMethod.GET);
        request.setBucket(this.bucket);
        request.setKey(this.key);
        request.getQueryParams().put("acl", "");
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }
}

