/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.service.request;

import com.ksyun.ks3.exception.client.ClientIllegalArgumentExceptionGenerator;
import com.ksyun.ks3.http.HttpMethod;
import com.ksyun.ks3.http.Request;
import com.ksyun.ks3.service.request.Ks3WebServiceRequest;
import com.ksyun.ks3.utils.StringUtils;

public class ListMultipartUploadsRequest
extends Ks3WebServiceRequest {
    private String bucket;
    private String delimiter;
    private String keyMarker;
    private String uploadIdMarker;
    private Integer maxUploads;
    private String prefix;
    private String encodingType;

    public ListMultipartUploadsRequest(String bucketName) {
        this.bucket = bucketName;
    }

    public ListMultipartUploadsRequest(String bucketName, String prefix) {
        this.bucket = bucketName;
        this.setPrefix(prefix);
    }

    public ListMultipartUploadsRequest(String bucketName, String prefix, String keyMarker, String uploadIdMarker) {
        this.bucket = bucketName;
        this.setPrefix(prefix);
        this.setKeyMarker(keyMarker);
        this.setUploadIdMarker(uploadIdMarker);
    }

    @Override
    public void validateParams() throws IllegalArgumentException {
        if (StringUtils.isBlank(this.bucket)) {
            throw ClientIllegalArgumentExceptionGenerator.notNull("bucketName");
        }
        if (this.maxUploads != null && (this.maxUploads > 1000 || this.maxUploads < 1)) {
            throw ClientIllegalArgumentExceptionGenerator.between("maxUploads", String.valueOf(this.maxUploads), "1", "1000");
        }
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getKeyMarker() {
        return this.keyMarker;
    }

    public void setKeyMarker(String keyMarker) {
        this.keyMarker = keyMarker;
    }

    public String getUploadIdMarker() {
        return this.uploadIdMarker;
    }

    public void setUploadIdMarker(String uploadIdMarker) {
        this.uploadIdMarker = uploadIdMarker;
    }

    public Integer getMaxUploads() {
        return this.maxUploads;
    }

    public void setMaxUploads(Integer maxUploads) {
        this.maxUploads = maxUploads;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    public void setEncodingType(String encodingType) {
        this.encodingType = encodingType;
    }

    @Override
    public void buildRequest(Request request) {
        request.setMethod(HttpMethod.GET);
        request.setBucket(this.bucket);
        request.getQueryParams().put("uploads", null);
        request.addQueryParamIfNotNull("prefix", this.prefix);
        request.addQueryParamIfNotNull("key-marker", this.keyMarker);
        request.addQueryParamIfNotNull("upload-id-\u200bmarker", this.uploadIdMarker);
        request.addQueryParamIfNotNull("delimiter", this.delimiter);
        if (this.maxUploads != null) {
            request.addQueryParamIfNotNull("max-uploads", String.valueOf(this.maxUploads));
        }
        if (!StringUtils.isBlank(this.encodingType)) {
            request.addQueryParamIfNotNull("encoding-type", this.encodingType);
        }
    }
}

